/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Singleton;
import org.jclouds.azureblob.options.ListBlobsOptions;
import org.jclouds.blobstore.options.ListContainerOptions;

@Singleton
public class ListOptionsToListBlobsOptions
implements Function<ListContainerOptions, ListBlobsOptions> {
    public ListBlobsOptions apply(ListContainerOptions from) {
        Preconditions.checkNotNull((Object)from, (Object)"set options to instance NONE instead of passing null");
        if (from.getDir() != null && from.getPrefix() != null) {
            throw new IllegalArgumentException("Cannot set both directory and prefix");
        }
        if ((from.getDir() != null || from.isRecursive()) && from.getDelimiter() != null) {
            throw new IllegalArgumentException("Cannot set delimiter and directory or recursive options together");
        }
        ListBlobsOptions httpOptions = new ListBlobsOptions();
        if (from.getDelimiter() != null) {
            httpOptions.delimiter(from.getDelimiter());
        }
        if (!from.isRecursive() && httpOptions.getDelimiter() == null) {
            httpOptions.delimiter("/");
        }
        if (from.getDir() != null) {
            httpOptions.prefix(from.getDir().endsWith("/") ? from.getDir() : from.getDir() + "/");
        }
        if (from.getPrefix() != null) {
            httpOptions.prefix(from.getPrefix());
        }
        if (from.getMarker() != null) {
            httpOptions.marker(from.getMarker());
        }
        if (from.getMaxResults() != null) {
            httpOptions.maxResults(from.getMaxResults());
        }
        if (from.isDetailed()) {
            httpOptions.includeMetadata();
        }
        return httpOptions;
    }
}

