/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.PrefixString;

import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.PrefixString.PrefixQueryException;
import org.jzkit.search.util.QueryModel.PrefixString.PrefixQueryLexer;

public class PrefixQueryParser {
    private int token = 0;
    private PrefixQueryLexer p;
    private String default_attrset = "bib-1";
    private static Properties default_conversion_rules = null;

    public static Properties getDefaultConversionRules() {
        if (default_conversion_rules == null) {
            default_conversion_rules = new Properties();
            URL config = PrefixQueryParser.class.getResource("ConversionRules.properties");
            if (config == null) {
                throw new RuntimeException("Unable to locate default conversion rules");
            }
            try {
                default_conversion_rules.load(config.openStream());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        return default_conversion_rules;
    }

    public PrefixQueryParser(Reader r) {
        this.p = new PrefixQueryLexer(r);
    }

    public InternalModelRootNode parse() throws PrefixQueryException {
        InternalModelRootNode result = new InternalModelRootNode();
        this.token = this.p.nextToken();
        if (this.token == 5) {
            this.token = this.p.nextToken();
            this.default_attrset = this.p.getString();
            this.token = this.p.nextToken();
            InternalModelNamespaceNode ns_node = new InternalModelNamespaceNode();
            result.setChild(ns_node);
            ns_node.setAttrset(this.default_attrset);
            ns_node.setChild(this.visitPrefixQuery(this.default_attrset));
        } else {
            result.setChild(this.visitPrefixQuery(null));
        }
        if (this.token != 10) {
            throw new PrefixQueryException("Unparsed text at end of PQF expression. Starts with" + this.p.getString());
        }
        return result;
    }

    public QueryNode visitPrefixQuery(String current_default_ns) throws PrefixQueryException {
        QueryNode qn = null;
        switch (this.token) {
            case 1: {
                this.token = this.p.nextToken();
                qn = new ComplexNode(this.visitPrefixQuery(current_default_ns), this.visitPrefixQuery(current_default_ns), 1);
                break;
            }
            case 2: {
                this.token = this.p.nextToken();
                qn = new ComplexNode(this.visitPrefixQuery(current_default_ns), this.visitPrefixQuery(current_default_ns), 2);
                break;
            }
            case 3: {
                this.token = this.p.nextToken();
                qn = new ComplexNode(this.visitPrefixQuery(current_default_ns), this.visitPrefixQuery(current_default_ns), 3);
                break;
            }
            case 6: {
                qn = this.visitQueryNode(current_default_ns);
                break;
            }
            case 4: {
                qn = this.visitQueryNode(current_default_ns);
            }
        }
        return qn;
    }

    public AttrPlusTermNode visitQueryNode(String current_default_ns) throws PrefixQueryException {
        AttrPlusTermNode apt = new AttrPlusTermNode();
        Vector<String> terms = new Vector<String>();
        while (this.token == 4) {
            int attr_type = 0;
            Object attr_val = null;
            String local_attrset = null;
            this.token = this.p.nextToken();
            if (this.token == 6) {
                local_attrset = this.p.getString();
                this.token = this.p.nextToken();
            }
            if (this.token != 11) {
                throw new PrefixQueryException("Unexpected error processing RPN query, expected attribute type");
            }
            attr_type = this.p.getInt();
            this.token = this.p.nextToken();
            if (this.token != 8) {
                throw new PrefixQueryException("Unexpected error processing RPN query, expected =");
            }
            this.token = this.p.nextToken();
            if (this.token == 11) {
                attr_val = BigInteger.valueOf(this.p.getInt());
                this.token = this.p.nextToken();
            } else if (this.token == 6) {
                attr_val = this.p.getString();
                this.token = this.p.nextToken();
            } else {
                throw new PrefixQueryException("Unexpected error processing RPN query, expected str or num attribute");
            }
            String attr_type_str = "" + attr_type;
            String lookup_str = null;
            lookup_str = local_attrset != null ? local_attrset + "." + attr_type : current_default_ns + "." + attr_type;
            String internal_attr_type = PrefixQueryParser.getDefaultConversionRules().getProperty(lookup_str);
            if (internal_attr_type == null) {
                throw new PrefixQueryException("Unable to convert prefix query attribute type " + lookup_str);
            }
            apt.setAttr(internal_attr_type, new AttrValue(local_attrset, attr_type_str + "." + attr_val));
        }
        if (this.token == 12) {
            this.token = this.p.nextToken();
            apt.setNodeName(this.p.getString());
            this.token = this.p.nextToken();
        }
        while (this.token == 6 || this.token == 11) {
            if (this.token == 6) {
                terms.addElement(this.p.getString());
            } else {
                terms.addElement("" + this.p.getNumber());
            }
            this.token = this.p.nextToken();
        }
        if (terms.size() > 1) {
            apt.setTerm(terms);
        } else if (terms.size() == 1) {
            apt.setTerm(terms.get(0));
        } else {
            throw new PrefixQueryException("No Terms");
        }
        return apt;
    }
}

