/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.PrefixString;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class PrefixQueryLexer {
    StreamTokenizer input = null;
    static final int ERROR = -1;
    static final int AND = 1;
    static final int OR = 2;
    static final int NOT = 3;
    static final int ATTR = 4;
    static final int ATTRSET = 5;
    static final int TERM = 6;
    static final int SPACE = 7;
    static final int EQUALS = 8;
    static final int EOL = 9;
    static final int EOF = 10;
    static final int NUMBER = 11;
    static final int ELEMENTNAME = 12;
    static final int PARAM = 13;

    public PrefixQueryLexer(Reader r) {
        this.input = new StreamTokenizer(r);
        this.input.resetSyntax();
        this.input.eolIsSignificant(true);
        this.input.parseNumbers();
        this.input.wordChars(97, 122);
        this.input.wordChars(65, 90);
        this.input.wordChars(48, 57);
        this.input.wordChars(95, 95);
        this.input.wordChars(45, 45);
        this.input.wordChars(64, 64);
        this.input.ordinaryChar(40);
        this.input.ordinaryChar(41);
        this.input.quoteChar(34);
        this.input.whitespaceChars(32, 32);
    }

    String getString() {
        return this.input.sval;
    }

    int getInt() {
        return (int)this.input.nval;
    }

    double getNumber() {
        return this.input.nval;
    }

    int nextToken() {
        int token = 0;
        try {
            switch (this.input.nextToken()) {
                case -1: {
                    token = 10;
                    break;
                }
                case 10: {
                    token = 9;
                    break;
                }
                case -3: {
                    if (this.input.sval.equalsIgnoreCase("@AND")) {
                        token = 1;
                        break;
                    }
                    if (this.input.sval.equalsIgnoreCase("@OR")) {
                        token = 2;
                        break;
                    }
                    if (this.input.sval.equalsIgnoreCase("@NOT")) {
                        token = 3;
                        break;
                    }
                    if (this.input.sval.equalsIgnoreCase("@ATTR")) {
                        token = 4;
                        break;
                    }
                    if (this.input.sval.equalsIgnoreCase("@ATTRSET")) {
                        token = 5;
                        break;
                    }
                    if (this.input.sval.equalsIgnoreCase("@ELEMENTNAME")) {
                        token = 12;
                        break;
                    }
                    if (this.input.sval.equalsIgnoreCase("@PARAM")) {
                        token = 13;
                        break;
                    }
                    token = 6;
                    break;
                }
                case -2: {
                    token = 11;
                    break;
                }
                case 61: {
                    token = 8;
                    break;
                }
                case 34: {
                    token = 6;
                }
            }
        }
        catch (IOException e) {
            token = 10;
        }
        return token;
    }
}

