/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.EmptyField;
import org.elasticsearch.script.Field;
import org.elasticsearch.script.LeafReaderContextSupplier;
import org.elasticsearch.search.lookup.LeafDocLookup;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class DocValuesDocReader
implements DocReader,
LeafReaderContextSupplier {
    protected LeafSearchLookup leafLookup;
    protected final LeafReaderContext leafReaderContext;
    protected final SearchLookup lookup;

    public DocValuesDocReader(SearchLookup lookup, LeafReaderContext leafContext) {
        this.lookup = lookup;
        this.leafReaderContext = leafContext;
        this.leafLookup = lookup.getLeafSearchLookup(this.leafReaderContext);
    }

    @Override
    public Field<?> field(String fieldName) {
        LeafDocLookup doc = this.leafLookup.doc();
        if (!doc.containsKey(fieldName)) {
            return new EmptyField(fieldName);
        }
        return ((ScriptDocValues)doc.get(fieldName)).toField(fieldName);
    }

    @Override
    public Stream<Field<?>> fields(String fieldGlob) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void setDocument(int docID) {
        this.leafLookup.setDocument(docID);
    }

    @Override
    public Map<String, Object> docAsMap() {
        return this.leafLookup.asMap();
    }

    @Override
    public Map<String, ScriptDocValues<?>> doc() {
        return this.leafLookup.doc();
    }

    @Override
    public LeafReaderContext getLeafReaderContext() {
        return this.leafReaderContext;
    }
}

