/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.IOException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.io.gass.client.GassException;
import org.globus.io.streams.HTTPOutputStream;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class GassOutputStream
extends HTTPOutputStream {
    public GassOutputStream(String host, int port, String file, long length, boolean append) throws GassException, GSSException, IOException {
        this(null, SelfAuthorization.getInstance(), host, port, file, length, append);
    }

    public GassOutputStream(GSSCredential cred, String host, int port, String file, long length, boolean append) throws GassException, GSSException, IOException {
        this(cred, SelfAuthorization.getInstance(), host, port, file, length, append);
    }

    public GassOutputStream(GSSCredential cred, Authorization auth, String host, int port, String file, long length, boolean append) throws GassException, GSSException, IOException {
        this.size = length;
        this.append = append;
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, cred, 0);
        context.setOption(GSSConstants.GSS_MODE, GSIConstants.MODE_SSL);
        GssSocketFactory factory = GssSocketFactory.getDefault();
        this.socket = factory.createSocket(host, port, context);
        ((GssSocket)this.socket).setAuthorization(auth);
        this.put(host, file, length, -1);
    }
}

