/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.IOException;
import java.io.OutputStream;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSink;

public class DataSinkStream
implements DataSink {
    protected OutputStream out;
    protected boolean autoFlush;
    protected boolean ignoreOffset;
    protected long offset = 0L;

    public DataSinkStream(OutputStream out) {
        this(out, false, false);
    }

    public DataSinkStream(OutputStream out, boolean autoFlush, boolean ignoreOffset) {
        this.out = out;
        this.autoFlush = autoFlush;
        this.ignoreOffset = ignoreOffset;
    }

    public void write(Buffer buffer) throws IOException {
        long bufOffset = buffer.getOffset();
        if (this.ignoreOffset || bufOffset == -1L || bufOffset == this.offset) {
            this.out.write(buffer.getBuffer(), 0, buffer.getLength());
            if (this.autoFlush) {
                this.out.flush();
            }
            this.offset += (long)buffer.getLength();
        } else {
            throw new IOException("Random offsets not supported.");
        }
    }

    public void close() throws IOException {
        this.out.close();
    }
}

