/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.component.csw.CatalogDispatcher;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.services.NotInReadOnlyModeService;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class CswPublicationDispatcher
extends NotInReadOnlyModeService {
    private Logger logger;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        super.init(appPath, config);
    }

    public Element serviceSpecificExec(Element params, ServiceContext context) throws Exception {
        Element info;
        String operation;
        this.logger = context.getLogger();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager settingMan = (SettingManager)gc.getBean(SettingManager.class);
        boolean cswEnable = settingMan.getValueAsBool("system/csw/enable", false);
        Element response = new Element("response");
        if (params.getName().equals("request")) {
            Map<String, String> hm = CatalogDispatcher.extractParams(params);
            operation = hm.get("request");
            if (operation == null) {
                Element info2 = new Element("info").setText("No 'request' parameter found");
                response.addContent((Content)info2);
                return response;
            }
        } else if (params.getName().equals("Envelope")) {
            Element soapBody = params.getChild("Body", Namespace.getNamespace((String)"http://www.w3.org/2003/05/soap-envelope"));
            List payloadList = soapBody.getChildren();
            Element payload = (Element)payloadList.get(0);
            operation = payload.getName();
        } else {
            operation = params.getName();
        }
        if (operation == null) {
            info = new Element("info").setText("Request parameter is not defined.");
            response.addContent((Content)info);
        } else if (!operation.equals("Harvest") && !operation.equals("Transaction")) {
            info = new Element("info").setText("Not a CSW Publication operation: " + operation + ". Did you mean to use the CSW Discovery service? Use service name /csw");
            response.addContent((Content)info);
        }
        if (!cswEnable) {
            this.logger.info("CSW is disabled");
            info = new Element("info").setText("CSW is disabled");
            response.addContent((Content)info);
        } else {
            response = ((CatalogDispatcher)gc.getBean(CatalogDispatcher.class)).dispatch(params, context);
        }
        return response;
    }
}

