/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.soap.util.IOUtils;

public class StringUtils {
    public static final String lineSeparator = System.getProperty("line.separator", "\n");
    public static String URI_SEPARATION_CHAR = "@";

    public static String getClassName(Class clazz) {
        String string = clazz.getName();
        return clazz.isArray() ? StringUtils.parseDescriptor(string) : string;
    }

    public static Reader getContentAsReader(URL uRL) throws SecurityException, IllegalArgumentException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        try {
            Object object = uRL.getContent();
            if (object == null) {
                throw new IllegalArgumentException("No content.");
            }
            if (object instanceof InputStream) {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                if (((Reader)inputStreamReader).ready()) {
                    return inputStreamReader;
                }
                throw new FileNotFoundException();
            }
            throw new IllegalArgumentException(object instanceof String ? (String)object : "This URL points to a: " + StringUtils.getClassName(object.getClass()));
        }
        catch (SecurityException securityException) {
            throw new SecurityException("Your JVM's SecurityManager has disallowed this.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("This file was not found: " + uRL);
        }
    }

    public static String getContentAsString(URL uRL) throws SecurityException, IllegalArgumentException, IOException {
        return IOUtils.getStringFromReader(StringUtils.getContentAsReader(uRL));
    }

    public static URL getURL(URL uRL, String string) throws MalformedURLException {
        return StringUtils.getURL(uRL, string, 1);
    }

    private static URL getURL(URL uRL, String string, int n) throws MalformedURLException {
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                throw new MalformedURLException("This file was not found: " + uRL2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = new URL("file", "", string);
            try {
                uRL2.openStream();
            }
            catch (IOException iOException) {
                String string2;
                String string3;
                if (uRL != null && (string3 = new File(string2 = uRL.getFile()).getParent()) != null && n < 3) {
                    return StringUtils.getURL(new URL("file", "", String.valueOf(string3) + '/'), string, n + 1);
                }
                throw new MalformedURLException("This file was not found: " + uRL2);
            }
        }
        return uRL2;
    }

    private static String parseDescriptor(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (cArray[n2] == '[') {
            ++n;
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (cArray[n2++]) {
            case 'B': {
                stringBuffer.append("byte");
                break;
            }
            case 'C': {
                stringBuffer.append("char");
                break;
            }
            case 'D': {
                stringBuffer.append("double");
                break;
            }
            case 'F': {
                stringBuffer.append("float");
                break;
            }
            case 'I': {
                stringBuffer.append("int");
                break;
            }
            case 'J': {
                stringBuffer.append("long");
                break;
            }
            case 'S': {
                stringBuffer.append("short");
                break;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                break;
            }
            case 'L': {
                stringBuffer.append(cArray, n2, cArray.length - n2 - 1);
                break;
            }
        }
        n2 = 0;
        while (n2 < n) {
            stringBuffer.append("[]");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String parseFullTargetObjectURI(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(URI_SEPARATION_CHAR);
        if (string != null && n != -1) {
            return string.substring(0, n);
        }
        return string;
    }
}

