/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.handlers;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.http.handlers.RedirectionRetryHandler;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;

@Singleton
public class GetJobRedirectionRetryHandler
extends RedirectionRetryHandler {
    private final Payload emptyPayload = Payloads.newPayload((Object)new byte[0]);

    @Inject
    protected GetJobRedirectionRetryHandler(BackoffLimitedRetryHandler backoffHandler) {
        super(backoffHandler);
        this.emptyPayload.getContentMetadata().setContentType("application/json");
    }

    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        String location = response.getFirstHeaderOrNull("Location");
        if (location != null && location.indexOf("Job") != -1) {
            HttpRequest getRequest = ((HttpRequest.Builder)command.getCurrentRequest().toBuilder().method("GET").payload((Payload)null)).build();
            command.setCurrentRequest(getRequest);
        }
        return super.shouldRetryRequest(command, response);
    }
}

