/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import com.yammer.metrics.core.HealthCheck;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.client.RequestOptions;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.springframework.context.ConfigurableApplicationContext;

public class IndexReadOnlyHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            protected HealthCheck.Result check() {
                try {
                    ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
                    EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
                    String indexBlockRead = "index.blocks.read_only_allow_delete";
                    GetSettingsRequest request = new GetSettingsRequest();
                    request.names(new String[]{indexBlockRead});
                    GetSettingsResponse settings = searchMan.getClient().getClient().indices().getSettings(request, RequestOptions.DEFAULT);
                    Boolean isReadOnly = "true".equals(settings.getSetting(searchMan.getDefaultIndex(), indexBlockRead));
                    if (!isReadOnly.booleanValue()) {
                        return HealthCheck.Result.healthy((String)String.format("Index is writable.", searchMan.getDefaultIndex()));
                    }
                    return HealthCheck.Result.unhealthy((String)"Index is in Readonly mode. Check disk usage and/or indexing server logs.");
                }
                catch (Throwable e) {
                    return HealthCheck.Result.unhealthy((Throwable)e);
                }
            }
        };
    }
}

