/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.html;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.dlib.gui.CustomLook;

public class HtmlPanel
extends JScrollPane
implements HyperlinkListener {
    private JEditorPane jep = new JEditorPane(){

        public void paintComponent(Graphics graphics) {
            CustomLook.setup(graphics);
            super.paintComponent(graphics);
        }
    };
    private ActionListener al;
    private String actCmd;

    public HtmlPanel() {
        this(true, null);
    }

    public HtmlPanel(boolean bl, ActionListener actionListener) {
        this.jep.setEditable(false);
        if (bl) {
            this.jep.addHyperlinkListener(this);
        }
        this.setPreferredSize(new Dimension(700, 500));
        this.setVerticalScrollBarPolicy(22);
        this.setViewportView(this.jep);
        this.al = actionListener;
    }

    public void setPage(String string) {
        try {
            this.jep.setPage(string);
        }
        catch (IOException iOException) {
            System.out.println("HtmlPanel: exc --> " + iOException.getMessage());
            System.out.println("           url --> " + string);
        }
    }

    public void setActionCommand(String string) {
        this.actCmd = string;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                String string = hyperlinkEvent.getURL().toString();
                if (this.al != null) {
                    this.al.actionPerformed(new ActionEvent(string, 1001, this.actCmd));
                }
                this.setPage(string);
            }
        }
    }
}

