/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.MimeUtil2;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import org.fao.geonet.utils.Log;

public class MimeTypeFinder {
    private static boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static String blank = "";

    private static void registerMimeDetectors(boolean notLocal) {
        MimeUtil.unregisterMimeDetector((String)"eu.medsea.mimeutil.detector.WindowsRegistryMimeDetector");
        MimeUtil.unregisterMimeDetector((String)"eu.medsea.mimeutil.detector.OpendesktopMimeDetector");
        MimeUtil.unregisterMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
        MimeUtil.unregisterMimeDetector((String)"eu.medsea.mimeutil.detector.ExtensionMimeDetector");
        if (isWindows) {
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.WindowsRegistryMimeDetector");
        }
        if (!notLocal) {
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.OpendesktopMimeDetector");
            MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
        }
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.ExtensionMimeDetector");
    }

    public static String detectMimeTypeFile(String dir, String fName) {
        if (fName != null && dir != null) {
            if (fName.equals("")) {
                return blank;
            }
            MimeTypeFinder.registerMimeDetectors(false);
            try {
                File theFile = new File(dir, fName);
                Collection types = MimeUtil.getMimeTypes((File)theFile);
                boolean specific = false;
                for (MimeType mt : types) {
                    if (mt.getSpecificity() <= 1) continue;
                    specific = true;
                }
                if (specific) {
                    return MimeUtil.getMostSpecificMimeType((Collection)types).toString();
                }
                return ((MimeType)types.iterator().next()).toString();
            }
            catch (Exception e) {
                Log.error((String)"geonetwork", (Object)("Detect file mime type error: " + e.getMessage()), (Throwable)e);
                return MimeUtil2.UNKNOWN_MIME_TYPE.toString();
            }
        }
        return blank;
    }

    public static String detectMimeTypeUrl(String url) {
        if (url != null) {
            MimeTypeFinder.registerMimeDetectors(true);
            try {
                URL theUrl = new URL(url);
                MimeType mt = MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((URL)theUrl));
                return mt.toString();
            }
            catch (Exception e) {
                return MimeUtil2.UNKNOWN_MIME_TYPE.toString();
            }
        }
        return blank;
    }
}

