/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class JavaMailer {
    private Properties props = null;
    private Session mailSession = null;
    private Transport transport = null;
    private String smtpHost = null;
    private int smtpPort = 0;
    private boolean authentication;
    private String username = null;
    private String password = null;

    public JavaMailer(String smtpHost, String smtpPort, boolean authentication, String username, String password) {
        try {
            this.props = new Properties();
            this.props.put("mail.smtps.auth", String.valueOf(authentication));
            this.authentication = authentication;
            this.props.put("mail.smtp.host", smtpHost);
            this.props.put("mail.smtp.port", smtpPort);
            this.props.put("mail.smtp.starttls.enable", "true");
            this.props.put("mail.smtp.connectiontimeout", "10000");
            this.props.put("mail.smtp.timeout", "10000");
            this.props.put("mail.smtp.sendpartial", "true");
            this.mailSession = Session.getDefaultInstance((Properties)this.props, null);
            this.transport = this.mailSession.getTransport("smtp");
            this.smtpHost = smtpHost;
            this.smtpPort = Integer.parseInt(smtpPort);
            this.username = username;
            this.password = password;
        }
        catch (NoSuchProviderException x) {
            throw new ExceptionInInitializerError(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String subject, String text, String html, String sender, String ... recipients) throws MessagingException {
        try {
            MimeMessage message = new MimeMessage(this.mailSession);
            message.setSubject(subject);
            message.setFrom((Address)new InternetAddress(sender));
            if (recipients == null) {
                throw new MessagingException("No recipients specified to send e-mail, aborting.");
            }
            for (int i = 0; i < recipients.length; ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipients[i]));
            }
            MimeMultipart mpRoot = new MimeMultipart("mixed");
            MimeMultipart mpContent = new MimeMultipart("alternative");
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            contentPartRoot.setContent((Multipart)mpContent);
            mpRoot.addBodyPart((BodyPart)contentPartRoot);
            if (text != null && text.length() > 0) {
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(text);
                mpContent.addBodyPart((BodyPart)mbp1);
            }
            if (html != null && html.length() > 0) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)html, "text/html");
                mpContent.addBodyPart((BodyPart)messageBodyPart);
            }
            message.setContent((Multipart)mpRoot);
            message.saveChanges();
            String host = this.smtpHost;
            String username = this.username;
            String password = this.password;
            int smtpPort = this.smtpPort;
            if (this.authentication) {
                this.transport.connect(host, smtpPort, username, password);
            } else {
                this.transport.connect(host, smtpPort, null, null);
            }
            Address[] addresses = new Address[message.getRecipients(Message.RecipientType.TO).length];
            System.arraycopy(message.getRecipients(Message.RecipientType.TO), 0, addresses, 0, message.getRecipients(Message.RecipientType.TO).length);
            this.transport.sendMessage((Message)message, addresses);
        }
        finally {
            this.transport.close();
        }
    }
}

