/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.log4j.Logger;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.resources.CMISConfiguration;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;

public class CMISUtils {
    @Autowired
    CMISConfiguration cmisConfiguration;
    private Cache<String, Folder> folderCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public void invalidateFolderCache(String folderKey) throws ResourceNotFoundException {
        ArrayList cachedKeys = new ArrayList(this.folderCache.asMap().keySet());
        for (String cachedKey : cachedKeys) {
            if (!cachedKey.startsWith(folderKey)) continue;
            this.folderCache.invalidate((Object)cachedKey);
        }
    }

    public void invalidateFolderCacheItem(String folderKey) {
        this.folderCache.invalidate((Object)folderKey);
    }

    public Folder getFolderCache(String folderKey) throws ResourceNotFoundException, CmisPermissionDeniedException {
        return this.getFolderCache(folderKey, false);
    }

    public Folder getFolderCache(final String folderKey, final boolean refresh) throws ResourceNotFoundException, CmisPermissionDeniedException {
        Folder folder = null;
        final boolean[] foundWithoutCache = new boolean[]{false};
        try {
            folder = (Folder)this.folderCache.get((Object)folderKey, (Callable)new Callable<Folder>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Folder call() throws Exception {
                    try {
                        OperationContext oc = CMISUtils.this.cmisConfiguration.getClient().getDefaultContext();
                        if (refresh) {
                            oc = CMISUtils.this.createOperationContext();
                            oc.setCacheEnabled(false);
                        }
                        Folder folder = (Folder)CMISUtils.this.cmisConfiguration.getClient().getObjectByPath(folderKey, oc);
                        if (refresh) {
                            foundWithoutCache[0] = true;
                        }
                        return folder;
                    }
                    catch (CmisObjectNotFoundException e) {
                        Folder folder;
                        String parentFolderKey = folderKey.substring(0, folderKey.lastIndexOf(CMISUtils.this.cmisConfiguration.getFolderDelimiter()));
                        Folder subFolder = CMISUtils.this.getFolderCache(parentFolderKey, refresh);
                        1 var5_6 = this;
                        synchronized (var5_6) {
                            ObjectId objectId = CMISUtils.this.cmisConfiguration.getClient().createPath((ObjectId)subFolder, folderKey, "cmis:folder");
                            folder = (Folder)CMISUtils.this.cmisConfiguration.getClient().getObject(objectId);
                        }
                        if (refresh) {
                            foundWithoutCache[0] = true;
                        }
                        return folder;
                    }
                }
            });
        }
        catch (ExecutionException e) {
            throw new ResourceNotFoundException("Error getting resource from cache: " + folderKey, e);
        }
        if (refresh && !foundWithoutCache[0]) {
            try {
                folder.refresh();
            }
            catch (CmisObjectNotFoundException e) {
                this.folderCache.invalidate((Object)folderKey);
                folder = this.getFolderCache(folderKey, refresh);
            }
        }
        return folder;
    }

    public OperationContext createOperationContext() {
        return this.cmisConfiguration.getClient().createOperationContext(this.cmisConfiguration.getClient().getDefaultContext().getFilter(), this.cmisConfiguration.getClient().getDefaultContext().isIncludeAcls(), this.cmisConfiguration.getClient().getDefaultContext().isIncludeAllowableActions(), this.cmisConfiguration.getClient().getDefaultContext().isIncludePolicies(), this.cmisConfiguration.getClient().getDefaultContext().getIncludeRelationships(), this.cmisConfiguration.getClient().getDefaultContext().getRenditionFilter(), this.cmisConfiguration.getClient().getDefaultContext().isIncludePathSegments(), this.cmisConfiguration.getClient().getDefaultContext().getOrderBy(), this.cmisConfiguration.getClient().getDefaultContext().isCacheEnabled(), this.cmisConfiguration.getClient().getDefaultContext().getMaxItemsPerPage());
    }

    public Map<String, Document> getCmisObjectMap(Folder folder, String baseFolder) {
        return this.getCmisObjectMap(folder, baseFolder, null);
    }

    public Map<String, Document> getCmisObjectMap(Folder folder, String baseFolder, String suffixlessKeyFilename) {
        if (baseFolder == null) {
            baseFolder = "";
        }
        HashMap<String, Document> documentMap = new HashMap<String, Document>();
        for (CmisObject cmisObject : folder.getChildren()) {
            if (cmisObject instanceof Folder) {
                documentMap.putAll(this.getCmisObjectMap((Folder)cmisObject, baseFolder + this.cmisConfiguration.getFolderDelimiter() + cmisObject.getName(), suffixlessKeyFilename));
                return documentMap;
            }
            if (!(cmisObject instanceof Document) || suffixlessKeyFilename != null && !cmisObject.getName().startsWith(suffixlessKeyFilename)) continue;
            documentMap.put(baseFolder + this.cmisConfiguration.getFolderDelimiter() + cmisObject.getName(), (Document)cmisObject);
        }
        return documentMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Document saveDocument(String key, CmisObject cmisObject, Map<String, Object> properties, InputStream is, Date changeDate) throws IOException {
        Document doc;
        OperationContext oc = this.createOperationContext();
        oc.setCacheEnabled(false);
        int lastFolderDelimiterKeyIndex = key.lastIndexOf(this.cmisConfiguration.getFolderDelimiter());
        String filenameKey = key.substring(lastFolderDelimiterKeyIndex + 1);
        properties.put("cmis:objectTypeId", "cmis:document");
        properties.put("cmis:name", filenameKey);
        if (changeDate != null) {
            properties.put("cmis:lastModificationDate", changeDate);
        }
        int isLength = is.available();
        ContentStream contentStream = this.cmisConfiguration.getClient().getObjectFactory().createContentStream(key, (long)isLength, Files.probeContentType(new File(key).toPath()), is);
        if (cmisObject != null) {
            try {
                cmisObject.refresh();
            }
            catch (CmisObjectNotFoundException e) {
                cmisObject = null;
            }
        }
        if (cmisObject != null) {
            try {
                doc = (Document)cmisObject;
                if (this.cmisConfiguration.getVersioningState().equals((Object)VersioningState.MAJOR) && this.cmisConfiguration.isVersioningMajorOnUpdate().booleanValue() && doc.isVersionable() && doc.isMajorVersion().booleanValue()) {
                    if (doc.isVersionSeriesCheckedOut().booleanValue()) {
                        doc.cancelCheckOut();
                    }
                    ObjectId objectID = doc.checkOut();
                    CmisObject o = this.cmisConfiguration.getClient().getObject(objectID, oc);
                    ((Document)o).checkIn(true, properties, contentStream, null);
                } else {
                    doc.updateProperties(properties, true);
                    doc.setContentStream(contentStream, true, true);
                }
                if (this.cmisConfiguration.existSecondaryProperty()) {
                    doc = (Document)this.cmisConfiguration.getClient().getObjectByPath(key, oc);
                }
                if (!Logger.getLogger((String)"geonetwork.resources").isInfoEnabled()) return doc;
                Log.info((String)"geonetwork.resources", (Object)String.format("Updated resource '%s'. Current version '%s'.", key, doc.getVersionLabel()));
                return doc;
            }
            catch (CmisConstraintException e) {
                Log.warning((String)"geonetwork.resources", (Object)String.format("No allowed to modify existing resource '%s' due to constraint violation or lock.", key));
                throw new NotAllowedException(String.format("No allowed to modify existing resource '%s' due to constraint violation or lock.", key));
            }
            catch (CmisPermissionDeniedException e) {
                Log.warning((String)"geonetwork.resources", (Object)String.format("No permissions to update resource '%s'.", key));
                throw new NotAllowedException(String.format("No permissions to update resource '%s'.", key));
            }
        }
        String parentKey = key.substring(0, lastFolderDelimiterKeyIndex);
        try {
            Folder parentFolder = this.getFolderCache(parentKey, true);
            doc = parentFolder.createDocument(properties, contentStream, this.cmisConfiguration.getVersioningState());
            if (!Logger.getLogger((String)"geonetwork.resources").isInfoEnabled()) return doc;
            Log.info((String)"geonetwork.resources", (Object)String.format("Added resource '%s'.", doc.getPaths().get(0)));
            return doc;
        }
        catch (CmisPermissionDeniedException ex) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("No permissions to add resource '%s'.", key));
            throw new NotAllowedException(String.format("No permissions to add resource '%s'.", key));
        }
        catch (ResourceNotFoundException e) {
            throw new IOException("Error getting resource from cache: " + parentKey, e);
        }
    }
}

