/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.fao.geonet.kernel.schema.MetadataAttribute;

public class MetadataType {
    public boolean hasContainers = false;
    private String name;
    private boolean isOrType;
    private ArrayList<String> alElements = new ArrayList();
    private List<String> alTypes = new ArrayList<String>();
    private List<Integer> alMinCard = new ArrayList<Integer>();
    private List<Integer> alMaxCard = new ArrayList<Integer>();
    private List<MetadataAttribute> alAttribs = new ArrayList<MetadataAttribute>();
    private List<Boolean> alExamineSubs = new ArrayList<Boolean>();

    MetadataType() {
    }

    public int getElementCount() {
        return this.alElements.size();
    }

    public List<String> getElementList() {
        return (List)this.alElements.clone();
    }

    public String getElementAt(int pos) {
        return this.alElements.get(pos);
    }

    public String getElementTypeAt(int pos) {
        return this.alTypes.get(pos);
    }

    public int getMinCardinAt(int pos) {
        return this.alMinCard.get(pos);
    }

    public int getMaxCardinAt(int pos) {
        return this.alMaxCard.get(pos);
    }

    public boolean isOrType() {
        return this.isOrType;
    }

    void setOrType(boolean yesno) {
        this.isOrType = yesno;
    }

    public int getAttributeCount() {
        return this.alAttribs.size();
    }

    public MetadataAttribute getAttributeAt(int i) {
        return this.alAttribs.get(i);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAlElements() {
        return this.alElements;
    }

    public List<MetadataAttribute> getAlAttribs() {
        return this.alAttribs;
    }

    void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        if (this.isOrType) {
            res.append("IsOrType = TRUE ");
        } else {
            res.append("IsOrType = FALSE ");
        }
        for (int i = 0; i < this.alElements.size(); ++i) {
            String comp = this.getElementAt(i);
            int min = this.getMinCardinAt(i);
            int max = this.getMaxCardinAt(i);
            String sMax = max > 1 ? "n" : String.valueOf(max);
            res.append(comp).append("/").append(min).append("-").append(sMax).append(" ");
        }
        StringBuilder attrs = new StringBuilder();
        for (int i = 0; i < this.alAttribs.size(); ++i) {
            attrs.append("Attribute (").append(i).append(") ").append(this.getAttributeAt((int)i).name).append(": ");
            Set<String> alAtts = this.getAttributeAt((int)i).values;
            if (alAtts.size() > 0) {
                attrs.append(this.getAttributeAt((int)i).values);
                attrs.append(" ");
            }
            attrs.append("Default Value: ").append(this.getAttributeAt((int)i).defValue);
            if (!this.getAttributeAt((int)i).required) continue;
            attrs.append(" REQUIRED ");
        }
        if (attrs.length() > 0) {
            res.append(" Attributes: ").append((CharSequence)attrs);
        }
        return res.toString();
    }

    void addElementWithType(String name, String elementType, int minCard, int maxCard) {
        this.addElement(name, elementType, false, minCard, maxCard);
    }

    void addRefElementWithType(String name, String elementType, int minCard, int maxCard) {
        this.addElement(name, elementType, true, minCard, maxCard);
    }

    void addElement(String name, String elementType, Boolean examineElementSubs, int minCard, int maxCard) {
        if (this.alElements.contains(name) && this.alElements.indexOf(name) == this.alTypes.indexOf(elementType)) {
            return;
        }
        this.alElements.add(name);
        this.alTypes.add(elementType);
        this.alExamineSubs.add(examineElementSubs);
        this.alMinCard.add(minCard);
        this.alMaxCard.add(maxCard);
        if (name.contains("CHOICE_ELEMENT") || name.contains("GROUP_ELEMENT") || name.contains("SEQUENCE_ELEMENT")) {
            this.hasContainers = true;
        }
    }

    void addAttribute(MetadataAttribute ma) {
        this.alAttribs.add(ma);
    }
}

