/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager.base;

import java.nio.file.Path;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.exceptions.SchemaMatchConflictException;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseMetadataSchemaUtils
implements IMetadataSchemaUtils {
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private IMetadataUtils metadataUtils;

    @Override
    public MetadataSchema getSchema(String name) {
        return this.schemaManager.getSchema(name);
    }

    @Override
    public Set<String> getSchemas() {
        return this.schemaManager.getSchemas();
    }

    @Override
    public boolean existsSchema(String name) {
        return this.schemaManager.existsSchema(name);
    }

    @Override
    public Path getSchemaDir(String name) {
        return this.schemaManager.getSchemaDir(name);
    }

    @Override
    public String getMetadataSchema(String id) throws Exception {
        AbstractMetadata md = this.metadataUtils.findOne(id);
        if (md == null) {
            throw new IllegalArgumentException("Metadata not found for id : " + id);
        }
        return md.getDataInfo().getSchemaId();
    }

    @Override
    @CheckForNull
    public String autodetectSchema(Element md) throws SchemaMatchConflictException, NoSchemaMatchesException {
        return this.autodetectSchema(md, this.schemaManager.getDefaultSchema());
    }

    @Override
    @CheckForNull
    public String autodetectSchema(Element md, String defaultSchema) throws SchemaMatchConflictException, NoSchemaMatchesException {
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Autodetect schema for metadata with :\n * root element:'" + md.getQualifiedName() + "'\n * with namespace:'" + md.getNamespace() + "\n * with additional namespaces:" + md.getAdditionalNamespaces().toString()));
        }
        String schema = this.schemaManager.autodetectSchema(md, defaultSchema);
        if (Log.isDebugEnabled((String)"geonetwork.datamanager")) {
            Log.debug((String)"geonetwork.datamanager", (Object)("Schema detected was " + schema));
        }
        return schema;
    }
}

