/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.util.URIUtil;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.exceptions.LabelNotFoundException;
import org.fao.geonet.kernel.PrioritizedLangComparator;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.rdf.Selectors;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.jdom.Content;
import org.jdom.Element;

public class KeywordBean {
    private final Map<String, String> values = new LinkedHashMap<String, String>();
    private final Map<String, String> definitions = new LinkedHashMap<String, String>();
    private int id;
    private String code;
    private String coordEast = "";
    private String coordWest = "";
    private String coordSouth = "";
    private String coordNorth = "";
    private String thesaurusKey;
    private boolean selected;
    private String thesaurusTitle;
    private String thesaurusDate;
    private String downloadUrl;
    private String keywordUrl;
    private IsoLanguagesMapper isoLanguageMapper;
    private String defaultLang;

    public KeywordBean(IsoLanguagesMapper isoLangMapper) {
        this.isoLanguageMapper = isoLangMapper;
    }

    @JsonIgnore
    public static Element getComplexIso19139Elt(List<KeywordBean> kbList) {
        Element root = new Element("MD_Keywords", Geonet.Namespaces.GMD);
        Element cs = new Element("CharacterString", Geonet.Namespaces.GCO);
        Element an = new Element("Anchor", Geonet.Namespaces.GMX);
        ArrayList<Element> keywords = new ArrayList<Element>();
        Element type = null;
        Element thesaurusName = null;
        for (KeywordBean kb : kbList) {
            Element keyword = new Element("keyword", Geonet.Namespaces.GMD);
            if (kb.getUriCode() != null && kb.getUriCode().length() != 0) {
                an.setText(kb.getDefaultValue());
                an.setAttribute("href", URIUtil.encodePath((String)(kb.keywordUrl + kb.getUriCode())), Geonet.Namespaces.XLINK);
                keyword.addContent((Content)an.clone());
            } else {
                cs.setText(kb.getDefaultValue());
                keyword.addContent((Content)cs.clone());
            }
            keywords.add((Element)keyword.detach());
            if (type == null) {
                type = KeywordBean.createKeywordTypeElt(kb);
            }
            if (thesaurusName != null) continue;
            thesaurusName = KeywordBean.createThesaurusNameElt(kb);
        }
        root.addContent(keywords);
        root.addContent(type);
        root.addContent(thesaurusName);
        return root;
    }

    private static Element createKeywordTypeElt(KeywordBean kb) {
        Element type = new Element("type", Geonet.Namespaces.GMD);
        Element keywordTypeCode = new Element("MD_KeywordTypeCode", Geonet.Namespaces.GMD);
        keywordTypeCode.setAttribute("codeList", "http://www.isotc211.org/2005/resources/codeList.xml#MD_KeywordTypeCode");
        keywordTypeCode.setAttribute("codeListValue", kb.getType());
        type.addContent((Content)keywordTypeCode);
        return type;
    }

    private static Element createIdentifier(String authority, String downloadUrl) {
        Element result = new Element("identifier", Geonet.Namespaces.GMD);
        Element ident = new Element("MD_Identifier", Geonet.Namespaces.GMD);
        Element code = new Element("code", Geonet.Namespaces.GMD);
        Element gmxAnchor = new Element("Anchor", Geonet.Namespaces.GMX).setText(authority);
        gmxAnchor.setAttribute("href", downloadUrl, Geonet.Namespaces.XLINK);
        code.addContent((Content)gmxAnchor);
        ident.addContent((Content)code);
        result.addContent((Content)ident);
        return result;
    }

    private static Element createThesaurusNameElt(KeywordBean kb) {
        Element thesaurusName = new Element("thesaurusName", Geonet.Namespaces.GMD);
        Element citation = new Element("CI_Citation", Geonet.Namespaces.GMD);
        Element title = new Element("title", Geonet.Namespaces.GMD);
        Element cs = new Element("CharacterString", Geonet.Namespaces.GCO);
        Element date = new Element("date", Geonet.Namespaces.GMD);
        cs.setText(kb.thesaurusTitle);
        if (org.springframework.util.StringUtils.hasLength((String)kb.thesaurusDate)) {
            Element ciDateEl = new Element("CI_Date", Geonet.Namespaces.GMD);
            Element ciDateDateEl = new Element("date", Geonet.Namespaces.GMD);
            Element ciDateDateGcoDateEl = new Element("Date", Geonet.Namespaces.GCO);
            ciDateDateGcoDateEl.setText(kb.thesaurusDate);
            Element ciDateDatetypeEl = new Element("dateType", Geonet.Namespaces.GMD);
            Element ciDateDatetypeCodeEl = new Element("CI_DateTypeCode", Geonet.Namespaces.GMD);
            ciDateDatetypeCodeEl.setAttribute("codeList", "http://standards.iso.org/iso/19139/resources/gmxCodelists.xml#CI_DateTypeCode");
            ciDateDatetypeCodeEl.setAttribute("codeListValue", "publication");
            ciDateDatetypeEl.addContent((Content)ciDateDatetypeCodeEl);
            ciDateDateEl.addContent((Content)ciDateDateGcoDateEl);
            ciDateEl.addContent(0, (Content)ciDateDateEl);
            ciDateEl.addContent(1, (Content)ciDateDatetypeEl);
            date.addContent((Content)ciDateEl);
        } else {
            date.setAttribute("nilReason", "unknown", Geonet.Namespaces.GCO);
        }
        title.addContent((Content)cs.clone());
        Element id = KeywordBean.createIdentifier("geonetwork.thesaurus." + kb.thesaurusKey, kb.downloadUrl);
        citation.addContent(0, (Content)title);
        citation.addContent(1, (Content)date);
        citation.addContent(2, (Content)id);
        thesaurusName.addContent((Content)citation);
        return thesaurusName;
    }

    public KeywordBean setThesaurusInfo(Thesaurus thesaurus) {
        this.thesaurusKey = thesaurus.getKey();
        this.thesaurusDate = thesaurus.getDate();
        this.thesaurusTitle = thesaurus.getTitle();
        return this;
    }

    @JsonIgnore
    public boolean isSelected() {
        return this.selected;
    }

    public KeywordBean setSelected(boolean selected) {
        this.selected = selected;
        return this;
    }

    public String getThesaurusKey() {
        return this.thesaurusKey;
    }

    public KeywordBean setThesaurusKey(String thesaurusKey) {
        this.thesaurusKey = thesaurusKey;
        return this;
    }

    @JsonIgnore
    public String getThesaurusTitle() {
        return this.thesaurusTitle;
    }

    public void setThesaurusTitle(String thesaurusTitle) {
        this.thesaurusTitle = thesaurusTitle;
    }

    @JsonIgnore
    public String getThesaurusDate() {
        return this.thesaurusDate;
    }

    public void setThesaurusDate(String thesaurusDate) {
        this.thesaurusDate = thesaurusDate;
    }

    @JsonIgnore
    public String getKeywordUrl() {
        return this.keywordUrl;
    }

    public KeywordBean setKeywordUrl(String keywordUrl) {
        this.keywordUrl = keywordUrl;
        return this;
    }

    @JsonIgnore
    public String getDefaultLang() {
        return this.defaultLang;
    }

    public KeywordBean setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
        return this;
    }

    @JsonProperty(value="value")
    public String getDefaultValue() {
        return this.values.get(this.defaultLang);
    }

    @JsonIgnore
    public String getPreferredLabel(String langCode) {
        String preferredLabel = this.values.get(langCode);
        if (this.hasPreferredLabel(preferredLabel)) {
            return preferredLabel;
        }
        throw new LabelNotFoundException(this.noPreferredLabelMessage(langCode));
    }

    private String noPreferredLabelMessage(String langCode) {
        return "Could not find preferred label for language code " + langCode + " for the keyword uri " + this.getUriCode();
    }

    private boolean hasPreferredLabel(String preferredLabel) {
        return preferredLabel != null && !preferredLabel.isEmpty();
    }

    public Map<String, String> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public KeywordBean setValue(String value, String lang) {
        if (this.defaultLang == null && StringUtils.isNotEmpty((String)value)) {
            this.defaultLang = this.to3CharLang(lang);
        }
        this.values.put(this.to3CharLang(lang), value);
        return this;
    }

    @JsonProperty(value="definition")
    public String getDefaultDefinition() {
        return this.definitions.get(this.defaultLang);
    }

    public Map<String, String> getDefinitions() {
        return Collections.unmodifiableMap(this.definitions);
    }

    public KeywordBean setDefinition(String definition, String lang) {
        this.definitions.put(this.to3CharLang(lang), definition);
        return this;
    }

    @JsonIgnore
    public int getId() {
        return this.id;
    }

    public KeywordBean setId(int id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="uri")
    public String getUriCode() {
        return this.code;
    }

    public KeywordBean setUriCode(String code) {
        this.code = code;
        return this;
    }

    @JsonIgnore
    public String getRelativeCode() {
        if (this.code == null) {
            return "";
        }
        if (this.code.contains("#")) {
            return this.code.split("#")[1];
        }
        return this.code;
    }

    public KeywordBean setRelativeCode(String newCode) {
        this.code = this.getNameSpaceCode() + newCode;
        return this;
    }

    @JsonIgnore
    public String getNameSpaceCode() {
        if (this.code == null) {
            return "#";
        }
        if (this.code.contains("#")) {
            String[] parts = this.code.split("#", 2);
            return parts[0] + "#";
        }
        return "#";
    }

    private String asString(String s) {
        return s == null ? "" : s;
    }

    public String getCoordEast() {
        return this.asString(this.coordEast);
    }

    public KeywordBean setCoordEast(String coordEast) {
        this.coordEast = this.asString(coordEast);
        return this;
    }

    public String getCoordNorth() {
        return this.asString(this.coordNorth);
    }

    public KeywordBean setCoordNorth(String coordNorth) {
        this.coordNorth = this.asString(coordNorth);
        return this;
    }

    public String getCoordWest() {
        return this.asString(this.coordWest);
    }

    public KeywordBean setCoordWest(String coordWest) {
        this.coordWest = this.asString(coordWest);
        return this;
    }

    public String getCoordSouth() {
        return this.asString(this.coordSouth);
    }

    public KeywordBean setCoordSouth(String coordSouth) {
        this.coordSouth = this.asString(coordSouth);
        return this;
    }

    @JsonIgnore
    public String getType() {
        int tmpDotIndex = this.thesaurusKey.indexOf(46);
        return this.thesaurusKey.substring(tmpDotIndex + 1, this.thesaurusKey.indexOf(".", tmpDotIndex + 1));
    }

    @JsonIgnore
    public String getThesaurusType() {
        return StringUtils.substringBefore((String)this.thesaurusKey, (String)".");
    }

    @JsonIgnore
    public Element getIso19139() {
        Element ele = new Element("MD_Keywords", Geonet.Namespaces.GMD);
        Element el = new Element("keyword", Geonet.Namespaces.GMD);
        Element an = new Element("Anchor", Geonet.Namespaces.GMX);
        Element cs = new Element("CharacterString", Geonet.Namespaces.GCO);
        if (this.getUriCode() != null && this.getUriCode().length() != 0) {
            an.setText(this.getDefaultValue());
            an.setAttribute("href", URIUtil.encodePath((String)(this.keywordUrl + this.getUriCode())), Geonet.Namespaces.XLINK);
            el.addContent((Content)an);
        } else {
            cs.setText(this.getDefaultValue());
            el.addContent((Content)cs);
        }
        Element type = KeywordBean.createKeywordTypeElt(this);
        Element thesaurusName = KeywordBean.createThesaurusNameElt(this);
        ele.addContent((Content)el);
        ele.addContent((Content)type);
        ele.addContent((Content)thesaurusName);
        return ele;
    }

    @JsonIgnore
    public Element getSkos() {
        Element concept = new Element("Concept", Selectors.SKOS_NAMESPACE);
        if (this.getUriCode() != null && this.getUriCode().length() != 0) {
            concept.setAttribute("about", this.keywordUrl + this.getUriCode(), Selectors.RDF_NAMESPACE);
        }
        this.getValues().forEach((lang, value) -> {
            Element label = new Element("prefLabel", Selectors.SKOS_NAMESPACE);
            label.setAttribute("lang", this.getIsoLanguageMapper().iso639_2_to_iso639_1((String)lang), Geonet.Namespaces.XML);
            label.setText(value);
            concept.addContent((Content)label);
        });
        this.getDefinitions().forEach((lang, value) -> {
            Element label = new Element("scopeNote", Selectors.SKOS_NAMESPACE);
            label.setAttribute("lang", this.getIsoLanguageMapper().iso639_2_to_iso639_1((String)lang), Geonet.Namespaces.XML);
            label.setText(value);
            concept.addContent((Content)label);
        });
        return concept;
    }

    public Element toElement(String defaultLang, String ... langs) {
        defaultLang = this.to3CharLang(defaultLang);
        ArrayList<String> prioritizedList = new ArrayList<String>();
        prioritizedList.add(defaultLang);
        for (String s : langs) {
            s = this.to3CharLang(s);
            prioritizedList.add(s.toLowerCase());
        }
        TreeSet<String> languages = new TreeSet<String>(new PrioritizedLangComparator(defaultLang, prioritizedList));
        for (String l : this.values.keySet()) {
            l = this.to3CharLang(l);
            languages.add(l.toLowerCase());
        }
        Element elKeyword = new Element("keyword");
        Element elId = new Element("id");
        elId.addContent(Integer.toString(this.getId()));
        Element elCode = new Element("code");
        String code = this.getRelativeCode();
        elCode.setText(code);
        Element elSelected = new Element("selected");
        if (this.isSelected()) {
            elSelected.addContent("true");
        } else {
            elSelected.addContent("false");
        }
        elKeyword.addContent((Content)elId);
        elKeyword.addContent((Content)elCode);
        for (String language : languages) {
            if (!prioritizedList.isEmpty() && !prioritizedList.contains(language)) continue;
            Element elValue = new Element("value");
            elValue.addContent(this.values.get(language));
            elValue.setAttribute("lang", this.getIsoLanguageMapper().iso639_2_to_iso639_1(language, language.substring(2)).toUpperCase());
            elKeyword.addContent((Content)elValue);
        }
        Element elDefiniton = new Element("definition");
        elDefiniton.addContent(this.getDefaultDefinition());
        Element elUri = new Element("uri");
        elUri.addContent(this.getUriCode());
        String thesaurusType = this.getThesaurusKey();
        thesaurusType = thesaurusType.replace('.', '-');
        if (thesaurusType.contains("-")) {
            thesaurusType = thesaurusType.split("-")[1];
        }
        elKeyword.setAttribute("type", thesaurusType);
        Element elthesaurus = new Element("thesaurus").setText(this.getThesaurusKey());
        if (this.getCoordEast() != null && this.getCoordWest() != null && this.getCoordSouth() != null && this.getCoordNorth() != null) {
            Element elBbox = new Element("geo");
            Element elEast = new Element("east");
            elEast.addContent(this.getCoordEast());
            Element elWest = new Element("west");
            elWest.addContent(this.getCoordWest());
            Element elSouth = new Element("south");
            elSouth.addContent(this.getCoordSouth());
            Element elNorth = new Element("north");
            elNorth.addContent(this.getCoordNorth());
            elBbox.addContent((Content)elEast);
            elBbox.addContent((Content)elWest);
            elBbox.addContent((Content)elSouth);
            elBbox.addContent((Content)elNorth);
            elKeyword.addContent((Content)elBbox);
        }
        elKeyword.addContent((Content)elthesaurus);
        elKeyword.addContent((Content)elDefiniton);
        elKeyword.addContent((Content)elSelected);
        elKeyword.addContent((Content)elUri);
        return elKeyword;
    }

    @JsonIgnore
    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public KeywordBean setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    private String to3CharLang(String lang) {
        return this.getIsoLanguageMapper().iso639_1_to_iso639_2(lang.toLowerCase(), lang.toLowerCase());
    }

    @JsonIgnore
    public IsoLanguagesMapper getIsoLanguageMapper() {
        return this.isoLanguageMapper;
    }

    public KeywordBean setNamespaceCode(String namespace) {
        this.code = namespace.endsWith("#") ? namespace + this.getRelativeCode() : namespace + "#" + this.getRelativeCode();
        return this;
    }

    public KeywordBean removeValue(String lang) {
        this.values.remove(lang);
        return this;
    }

    public KeywordBean removeDefinition(String lang) {
        this.definitions.remove(lang);
        return this;
    }

    public String toString() {
        return this.getUriCode() + " : " + this.getDefaultValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeywordBean other = (KeywordBean)obj;
        return !(this.code == null ? other.code != null : !this.code.equals(other.code));
    }
}

