/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.collect.Iterators;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationId;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.domain.Schematron;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.kernel.ApplicableSchematron;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.springframework.context.ConfigurableApplicationContext;

public class AbstractSchematronValidator {
    protected void runSchematron(String lang, Path schemaDir, List<MetadataValidation> validations, Element schemaTronXmlOut, int metadataId, Element md, ApplicableSchematron applicable) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        ThesaurusManager thesaurusManager = (ThesaurusManager)applicationContext.getBean(ThesaurusManager.class);
        Schematron schematron = applicable.schematron;
        SchematronRequirement requirement = applicable.requirement;
        String ruleId = schematron.getRuleName();
        Element report = new Element("report", Edit.NAMESPACE);
        report.setAttribute("rule", ruleId, Edit.NAMESPACE);
        report.setAttribute("displayPriority", "" + schematron.getDisplayPriority(), Edit.NAMESPACE);
        report.setAttribute("dbident", String.valueOf(schematron.getId()), Edit.NAMESPACE);
        report.setAttribute("required", requirement.toString(), Edit.NAMESPACE);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("lang", lang);
            params.put("rule", ruleId);
            params.put("thesaurusDir", thesaurusManager.getThesauriDirectory().toString());
            Path file = schemaDir.resolve("schematron").resolve(schematron.getFile());
            Element xmlReport = Xml.transform((Element)md, (Path)file, params);
            if (xmlReport != null) {
                report.addContent((Content)xmlReport);
                Iterator i = xmlReport.getDescendants((Filter)new ElementFilter("fired-rule", Geonet.Namespaces.SVRL));
                int firedRules = Iterators.size((Iterator)i);
                i = xmlReport.getDescendants((Filter)new ElementFilter("failed-assert", Geonet.Namespaces.SVRL));
                int invalidRules = Iterators.size((Iterator)i);
                if (validations != null) {
                    validations.add(new MetadataValidation().setId(new MetadataValidationId(metadataId, ruleId)).setStatus(invalidRules != 0 ? MetadataValidationStatus.INVALID : MetadataValidationStatus.VALID).setRequired(Boolean.valueOf(requirement == SchematronRequirement.REQUIRED)).setNumTests(firedRules).setNumFailures(invalidRules));
                }
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.datamanager", (Object)("WARNING: schematron xslt " + ruleId + " failed"), (Throwable)e);
            Element errorReport = new Element("schematronVerificationError", Edit.NAMESPACE);
            errorReport.addContent("Schematron error ocurred, rules could not be verified: " + e.getMessage());
            report.addContent((Content)errorReport);
        }
        schemaTronXmlOut.addContent((Content)report);
    }
}

