/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.service.z3950server;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.LandscapeSpecification;
import org.jzkit.search.StatelessSearchResultsPageDTO;
import org.jzkit.search.impl.StatelessQueryService;
import org.jzkit.search.landscape.SimpleLandscapeSpecification;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.search.util.RecordModel.ArchetypeRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.search.util.ResultSet.IRResultSetInfo;
import org.jzkit.service.z3950server.ZSetInfo;
import org.jzkit.z3950.QueryModel.Type1QueryModel;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.RPNQuery_type;
import org.jzkit.z3950.server.BackendDeleteDTO;
import org.jzkit.z3950.server.BackendPresentDTO;
import org.jzkit.z3950.server.BackendSearchDTO;
import org.jzkit.z3950.server.BackendStatusReportDTO;
import org.jzkit.z3950.server.Z3950NonBlockingBackend;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JZKitBackend
implements Z3950NonBlockingBackend,
ApplicationContextAware {
    public static Log log = LogFactory.getLog(JZKitBackend.class);
    ApplicationContext ctx = null;
    private Map result_sets = new HashMap();
    private String impl_name = "JZKit Meta Search Service";
    private static RecordFormatSpecification def_request_spec = new ArchetypeRecordFormatSpecification("F");

    public JZKitBackend() {
        log.debug((Object)("New JZKitBackend " + this.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        String result = "ERROR";
        try {
            String classContainer = JZKitBackend.class.getProtectionDomain().getCodeSource().getLocation().toString();
            URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(manifestUrl.openStream());
            Attributes atts = manifest.getMainAttributes();
            result = atts.getValue("Implementation-Version");
        }
        catch (Exception e) {
            log.error((Object)"Problem extracting server version from manifest", (Throwable)e);
        }
        return result;
    }

    public String getImplName() {
        return this.impl_name;
    }

    public void setImplName(String impl_name) {
        this.impl_name = impl_name;
    }

    public void search(BackendSearchDTO bsr) {
        log.debug((Object)("JZKitBackend::search " + this.hashCode()));
        Type1QueryModel qm = new Type1QueryModel((RPNQuery_type)bsr.query.o);
        try {
            StatelessQueryService sqs = (StatelessQueryService)this.ctx.getBean("StatelessQueryService");
            String query_id = null;
            SimpleLandscapeSpecification landscape = new SimpleLandscapeSpecification(bsr.database_names);
            ExplicitRecordFormatSpecification exp = null;
            StatelessSearchResultsPageDTO res = sqs.getResultsPageFor(query_id, (QueryModel)qm, (LandscapeSpecification)landscape, 0, 0, def_request_spec, exp, null);
            log.debug((Object)("Search status = " + res.getSearchStatus()));
            if (res.getSearchStatus() == 8) {
                bsr.search_status = false;
                bsr.result_count = 0;
            } else {
                bsr.search_status = true;
                bsr.result_count = res.getRecordCount();
            }
            bsr.result_set_status = 1;
            bsr.status_report = this.createStatusReport(res.result_set_info);
            log.debug((Object)("Search: result set name :" + bsr.result_set_name));
            if (bsr.result_set_name != null && bsr.result_set_name.length() > 0) {
                this.result_sets.put(bsr.result_set_name, new ZSetInfo(query_id, (QueryModel)qm, (LandscapeSpecification)landscape));
            } else {
                this.result_sets.put("Default", new ZSetInfo(query_id, (QueryModel)qm, (LandscapeSpecification)landscape));
            }
            log.debug((Object)("jzkit_backend result sets size now " + this.result_sets.size() + " in backend " + this.hashCode()));
        }
        catch (SearchException se) {
            log.error((Object)"Problem", (Throwable)se);
            bsr.search_status = false;
            bsr.diagnostic_code = JZKitBackend.JZKitToDiag1(se.error_code);
            bsr.result_set_status = 3;
            if (bsr.diagnostic_code > 0L) {
                if (se.getMessage() != null) {
                    bsr.diagnostic_addinfo = se.getMessage();
                }
                bsr.diagnostic_data = se.diagnostic_data;
            }
        }
        catch (IRResultSetException irrse) {
            log.error((Object)"Problem", (Throwable)irrse);
            bsr.search_status = false;
        }
        catch (InvalidQueryException iqe) {
            log.error((Object)"Problem", (Throwable)iqe);
            bsr.search_status = false;
        }
        catch (Exception e) {
            log.error((Object)"Problem", (Throwable)e);
            bsr.search_status = false;
        }
        bsr.assoc.notifySearchResult(bsr);
    }

    private BackendStatusReportDTO createStatusReport(IRResultSetInfo rsi) {
        BackendStatusReportDTO result = new BackendStatusReportDTO();
        result.source_id = rsi.name;
        result.result_set_status = rsi.status;
        result.result_count = rsi.total_fragment_count;
        result.status_string = rsi.last_message;
        if (rsi.record_sources != null) {
            result.child_reports = new ArrayList();
            Iterator i = rsi.record_sources.iterator();
            while (i.hasNext()) {
                result.child_reports.add(this.createStatusReport((IRResultSetInfo)i.next()));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void present(BackendPresentDTO bpr) {
        try {
            log.debug((Object)("JZKitBackend::present - " + this.hashCode()));
            log.debug((Object)("looking for archetype: " + bpr.archetype + ", explicit=" + bpr.explicit));
            log.debug((Object)("looking for result set: " + bpr.result_set_name));
            log.debug((Object)("jzkit_backend result sets size " + this.result_sets.size() + " in backend " + this.hashCode()));
            ZSetInfo zsi = (ZSetInfo)this.result_sets.get(bpr.result_set_name);
            if (zsi != null) {
                StatelessQueryService sqs = (StatelessQueryService)this.ctx.getBean("StatelessQueryService");
                log.debug((Object)"Located result set info");
                StatelessSearchResultsPageDTO res = sqs.getResultsPageFor(zsi.getSetname(), zsi.getQueryModel(), zsi.getLandscape(), bpr.start, bpr.count, def_request_spec, bpr.explicit, null);
                bpr.total_hits = res.total_hit_count;
                bpr.result_records = res.getRecords();
                if (bpr.start > bpr.count) {
                    log.debug((Object)"Present out of range.. set error code");
                }
            } else {
                log.debug((Object)"Unable to locate result set");
            }
            bpr.next_result_set_position = bpr.start + bpr.count;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug((Object)"calling notifyPresentResult");
        bpr.assoc.notifyPresentResult(bpr);
    }

    public void deleteResultSet(BackendDeleteDTO del_req) {
        log.debug((Object)"JZKitBackend::deleteResultSet");
        del_req.assoc.notifyDeleteResult(del_req);
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    private static int JZKitToDiag1(int code) {
        int result = 0;
        switch (code) {
            case 1: {
                result = 2;
                break;
            }
            case 2: {
                result = 235;
                break;
            }
            case 3: {
                result = 114;
                break;
            }
            case 4: {
                result = 113;
                break;
            }
        }
        return result;
    }

    public static String getDiag1AddinfoString(long bib1_diag_code) {
        return "{1}";
    }
}

