/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.service;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.SearchSessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import trmi.Naming;

public class RMIService
implements ApplicationContextAware,
InitializingBean {
    private static Log log = LogFactory.getLog(RMIService.class);
    private String service_url = null;
    private String service_interface = null;
    private int service_port;
    private ApplicationContext ctx;

    public RMIService(ApplicationContext ctx, String service_url) {
        this.ctx = ctx;
        this.service_url = service_url;
    }

    public RMIService() {
    }

    public void setServiceURL(String service_url) {
        this.service_url = service_url;
    }

    public String getServiceURL() {
        return this.service_url;
    }

    public void setServicePort(int service_port) {
        this.service_port = service_port;
    }

    public int getServicePort() {
        return this.service_port;
    }

    public void setServiceInterface(String service_interface) {
        this.service_interface = service_interface;
    }

    public String getServiceInterface() {
        return this.service_interface;
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    protected Registry getRegistry(int registryPort) throws RemoteException {
        Registry registry;
        log.debug((Object)("Looking for RMI registry at port '" + registryPort + "'"));
        try {
            registry = LocateRegistry.getRegistry(registryPort);
            registry.list();
        }
        catch (RemoteException ex) {
            log.debug((Object)"Could not detect RMI registry - creating new one");
            registry = LocateRegistry.createRegistry(registryPort);
        }
        return registry;
    }

    public void afterPropertiesSet() throws Exception {
        log.debug((Object)("Rebind component " + this.service_url));
        SearchSessionFactory search_session_factory = (SearchSessionFactory)this.ctx.getBean("SearchSessionFactory");
        try {
            this.getRegistry(this.service_port);
            Naming.rebind((String)this.service_url, (Object)search_session_factory, (Class[])new Class[]{Class.forName(this.service_interface)});
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
    }
}

