/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.Profile;

import java.sql.Timestamp;
import java.util.logging.Logger;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.jzkit.search.util.Profile.ProfileServiceException;
import org.jzkit.search.util.Profile.QueryVerifyResult;
import org.jzkit.search.util.Profile.RuleNodeDBO;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.springframework.context.ApplicationContext;

@Entity
@Table(name="JZ_PROFILE")
public class ProfileDBO {
    private Timestamp last_updated;
    private Long id;
    private String code;
    private String profile_name;
    private RuleNodeDBO rule_node;
    private static Logger log = Logger.getLogger(ProfileDBO.class.getName());

    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="CODE", length=20)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setProfileName(String profile_name) {
        this.profile_name = profile_name;
    }

    @Column(name="PROFILE_NAME", length=40)
    public String getProfileName() {
        return this.profile_name;
    }

    public void setValidAttrRule(RuleNodeDBO rule_node) {
        this.rule_node = rule_node;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="RULE_NODE_ID")
    public RuleNodeDBO getValidAttrRule() {
        return this.rule_node;
    }

    public boolean isQueryConformant(QueryModel qm, ApplicationContext ctx) throws ProfileServiceException {
        boolean result = true;
        try {
            result = this.visit((QueryNode)qm.toInternalQueryModel(ctx), null, new QueryVerifyResult());
        }
        catch (InvalidQueryException iqe) {
            throw new ProfileServiceException(iqe.toString());
        }
        return result;
    }

    private boolean visit(QueryNode qn, String default_namespace, QueryVerifyResult qvr) throws InvalidQueryException {
        if (qn instanceof InternalModelRootNode) {
            InternalModelRootNode imrn = (InternalModelRootNode)qn;
            return this.visit(imrn.getChild(), default_namespace, qvr);
        }
        if (qn instanceof InternalModelNamespaceNode) {
            InternalModelNamespaceNode imns = (InternalModelNamespaceNode)qn;
            return this.visit(imns.getChild(), imns.getAttrset(), qvr);
        }
        if (qn instanceof ComplexNode) {
            ComplexNode cn = (ComplexNode)qn;
            return this.visit(cn.getLHS(), default_namespace, qvr) && this.visit(cn.getRHS(), default_namespace, qvr);
        }
        if (qn instanceof AttrPlusTermNode) {
            return this.rule_node.isValid(default_namespace, (AttrPlusTermNode)qn, qvr);
        }
        return false;
    }

    public boolean isValid(AttrPlusTermNode aptn, String default_namespace) throws ProfileServiceException {
        return this.validate(aptn, default_namespace).queryIsValid();
    }

    public QueryVerifyResult validate(AttrPlusTermNode aptn, String default_namespace) throws ProfileServiceException {
        QueryVerifyResult qvr = new QueryVerifyResult();
        try {
            this.visit((QueryNode)aptn, default_namespace, qvr);
        }
        catch (InvalidQueryException iqe) {
            throw new ProfileServiceException(iqe.toString());
        }
        return qvr;
    }

    @Column(name="LAST_UPDATED")
    public Timestamp getLastUpdated() {
        return this.last_updated;
    }

    public void setLastUpdated(Timestamp last_updated) {
        this.last_updated = last_updated;
    }
}

