/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jzkit.ServiceDirectory.CollectionDescriptionDBO;
import org.jzkit.configuration.api.Configuration;
import org.jzkit.configuration.api.ConfigurationException;
import org.jzkit.configuration.api.RecordMappingInformationDBO;
import org.jzkit.search.ExplainInformationDTO;
import org.jzkit.search.LandscapeSpecification;
import org.jzkit.search.SearchSession;
import org.jzkit.search.SearchSessionFactory;
import org.jzkit.search.StatelessSearchResultsPageDTO;
import org.jzkit.search.impl.StatelessQueryService;
import org.jzkit.search.provider.iface.SearchException;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchSessionFactoryImpl
implements SearchSessionFactory,
ApplicationContextAware {
    private ApplicationContext ctx;
    private StatelessQueryService stateless_query_service = null;
    private Map<String, WeakReference> sessions = new WeakHashMap<String, WeakReference>();

    @Override
    public SearchSession getSearchSession() {
        SearchSession result = (SearchSession)this.ctx.getBean("SearchSession");
        this.sessions.put(result.getSessionId(), new WeakReference<SearchSession>(result));
        return result;
    }

    @Override
    public SearchSession getSearchSession(String session_type) {
        SearchSession result = (SearchSession)this.ctx.getBean("SearchSession");
        result.setType(session_type);
        this.sessions.put(result.getSessionId(), new WeakReference<SearchSession>(result));
        return result;
    }

    @Override
    public StatelessSearchResultsPageDTO getResultsPageFor(String result_set_id, QueryModel model, LandscapeSpecification landscape, int first_hit, int num_hits, RecordFormatSpecification request_spec, ExplicitRecordFormatSpecification display_spec, Map additional_properties) throws SearchException, IRResultSetException, InvalidQueryException {
        return this.stateless_query_service.getResultsPageFor(result_set_id, model, landscape, first_hit, num_hits, request_spec, display_spec, additional_properties);
    }

    @Override
    public StatelessSearchResultsPageDTO getResultsPageFor(String result_set_id, String model_type, String model_str, String landscape_str, int first_hit, int num_hits, RecordFormatSpecification request_spec, ExplicitRecordFormatSpecification display_spec, Map additional_properties) throws SearchException, IRResultSetException, InvalidQueryException {
        return this.stateless_query_service.getResultsPageFor(result_set_id, model_type, model_str, landscape_str, first_hit, num_hits, request_spec, display_spec, additional_properties);
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void init() {
        this.stateless_query_service = (StatelessQueryService)this.ctx.getBean("StatelessQueryService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExplainInformationDTO explain() {
        ExplainInformationDTO result = new ExplainInformationDTO();
        Configuration directory = (Configuration)this.ctx.getBean("JZKitConfig");
        try {
            Iterator i = directory.enumerateVisibleCollections();
            while (i.hasNext()) {
                CollectionDescriptionDBO ci = (CollectionDescriptionDBO)i.next();
                RecordMappingInformationDBO rec_info = new RecordMappingInformationDBO();
                result.getDatabaseInfo().add(rec_info);
            }
        }
        catch (ConfigurationException ce) {
            ce.printStackTrace();
        }
        return result;
    }

    @Override
    public List<SearchSession> activeSessions() {
        ArrayList<SearchSession> result = new ArrayList<SearchSession>();
        for (WeakReference wr : this.sessions.values()) {
            SearchSession ss = (SearchSession)wr.get();
            if (ss == null) continue;
            result.add(ss);
        }
        return result;
    }

    @Override
    public SearchSession getSession(String id) {
        SearchSession result = null;
        WeakReference wr = this.sessions.get(id);
        if (wr != null) {
            result = (SearchSession)wr.get();
        }
        return result;
    }
}

