/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.config.CinderHttpApiModule;
import org.jclouds.openstack.cinder.v1.config.CinderParserModule;
import org.jclouds.openstack.keystone.auth.config.AuthenticationModule;
import org.jclouds.openstack.keystone.catalog.config.ServiceCatalogModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

public class CinderApiMetadata
extends BaseHttpApiMetadata<CinderApi> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public CinderApiMetadata() {
        this(new Builder());
    }

    protected CinderApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "volume");
        properties.setProperty("jclouds.keystone.version", "2");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<CinderApi, Builder> {
        protected Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-cinder")).name("OpenStack Cinder Folsom API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("Keystone base URL ending in /v2.0/")).documentation(URI.create("http://api.openstack.org/"))).version("1")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(CinderApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(AuthenticationModule.class).add(ServiceCatalogModule.class).add(ServiceCatalogModule.RegionModule.class).add(CinderParserModule.class).add(CinderHttpApiModule.class).build());
        }

        public CinderApiMetadata build() {
            return new CinderApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

