/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.fao.geonet.utils.Log;

public class TransformerFactoryFactory {
    public static final String SYSTEM_PROPERTY_NAME = "javax.xml.transform.TransformerFactory";
    public static final String TRANSFORMER_PATH = "/WEB-INF/classes/META-INF/services/javax.xml.transform.TransformerFactory";
    private static TransformerFactory factory;

    public static void init(String implementationName) {
        TransformerFactoryFactory.debug("Implementation name: " + implementationName);
        factory = implementationName != null && implementationName.length() > 0 ? TransformerFactory.newInstance(implementationName, null) : TransformerFactory.newInstance();
    }

    public static TransformerFactory getTransformerFactory() throws TransformerConfigurationException {
        if (factory == null) {
            TransformerFactoryFactory.debug("TransformerFactoryFactory is null. Initializing ...");
            TransformerFactoryFactory.init(null);
        }
        TransformerFactoryFactory.debug("TransformerFactoryFactory: " + factory.getClass().getName() + " produces transformer implementation " + factory.newTransformer().getClass().getName());
        return factory;
    }

    public static void setTransformerFactory(TransformerFactory _factory) {
        factory = _factory;
    }

    private static void debug(String message) {
        Log.debug("jeeves.transformerFactory", message);
    }
}

