/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.util.List;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public final class SOAPUtil {
    public static final Namespace NAMESPACE_ENV = Namespace.getNamespace((String)"env", (String)"http://www.w3.org/2003/05/soap-envelope");

    private SOAPUtil() {
    }

    public static Element embed(Element response) {
        Element envl = new Element("Envelope", NAMESPACE_ENV);
        Element body = new Element("Body", NAMESPACE_ENV);
        envl.addContent((Content)body);
        body.addContent((Content)response);
        return envl;
    }

    public static Element embedExc(Element error, boolean sender, String errorCode, String message) {
        Namespace ns = NAMESPACE_ENV;
        Element fault = new Element("Fault", ns);
        Element code = new Element("Code", ns);
        fault.addContent((Content)code);
        String type = sender ? "env:Sender" : "env:Receiver";
        Element value = new Element("Value", ns);
        value.setText(type);
        code.addContent((Content)value);
        Element subCode = new Element("Subcode", ns);
        code.addContent((Content)subCode);
        value = new Element("Value", ns);
        value.setText(errorCode);
        subCode.addContent((Content)value);
        Element reason = new Element("Reason", ns);
        fault.addContent((Content)reason);
        Element text = new Element("Text", ns);
        reason.addContent((Content)text);
        text.setText(message);
        text.setAttribute("lang", "en", Namespace.XML_NAMESPACE);
        Element detail = new Element("Detail", ns);
        detail.addContent((Content)error);
        fault.addContent((Content)detail);
        return SOAPUtil.embed(fault);
    }

    public static Element unembed(Element envelope) throws MissingParameterEx {
        Namespace ns = envelope.getNamespace();
        Element body = envelope.getChild("Body", ns);
        if (body == null) {
            throw new MissingParameterEx("Body", envelope);
        }
        List list = body.getChildren();
        if (list.size() == 0) {
            throw new MissingParameterEx("*request*", body);
        }
        return (Element)list.get(0);
    }

    public static boolean isEnvelope(Element elem) {
        if (!elem.getName().equals("Envelope")) {
            return false;
        }
        Namespace ns = elem.getNamespace();
        return ns.getURI().equals(NAMESPACE_ENV.getURI());
    }
}

