/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.xml.datatypes;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class DateTime
implements Cloneable,
Comparable {
    private String _dateTimeString;
    private boolean _isNegativeYear;
    private String _year;
    private String _months;
    private String _days;
    private String _hours;
    private String _minutes;
    private String _seconds;
    private String _fractionalSeconds;
    private boolean _isNegativeTimezone;
    private String _hoursTimezone;
    private String _minutesTimezone;
    private int _iYear;
    private int _iMonths;
    private int _iDays;
    private int _iHours;
    private int _iMinutes;
    private int _iSeconds;
    private double _iFractionalSeconds;
    private int _iHoursTimezone;
    private int _iMinutesTimezone;
    private boolean _isNormalized = false;

    public DateTime(String dateTimeString) {
        this._dateTimeString = dateTimeString;
        this._parseDateTimeString();
        this._setNumericFields();
        this._validateFieldValues();
    }

    private void _parseDateTimeString() {
        if (this._dateTimeString.length() < 19) {
            throw new IllegalArgumentException("String value too short to be a valid xsd:dateTime value: " + this._dateTimeString);
        }
        String errMsg = "Invalid xsd:dateTime value: " + this._dateTimeString;
        StringTokenizer st = new StringTokenizer(this._dateTimeString, "+-:.TZ", true);
        try {
            String token;
            this._year = st.nextToken();
            this._isNegativeYear = this._year.equals("-");
            if (this._isNegativeYear) {
                this._year = st.nextToken();
            }
            this._verifyTokenValue(st.nextToken(), "-", errMsg);
            this._months = st.nextToken();
            this._verifyTokenValue(st.nextToken(), "-", errMsg);
            this._days = st.nextToken();
            this._verifyTokenValue(st.nextToken(), "T", errMsg);
            this._hours = st.nextToken();
            this._verifyTokenValue(st.nextToken(), ":", errMsg);
            this._minutes = st.nextToken();
            this._verifyTokenValue(st.nextToken(), ":", errMsg);
            this._seconds = st.nextToken();
            String string = token = st.hasMoreTokens() ? st.nextToken() : null;
            if (".".equals(token)) {
                this._fractionalSeconds = st.nextToken();
                String string2 = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if ("+".equals(token) || "-".equals(token)) {
                this._isNegativeTimezone = "-".equals(token);
                this._hoursTimezone = st.nextToken();
                this._verifyTokenValue(st.nextToken(), ":", errMsg);
                this._minutesTimezone = st.nextToken();
            } else if ("Z".equals(token)) {
                this._isNegativeTimezone = false;
                this._minutesTimezone = "00";
                this._hoursTimezone = "00";
            }
            if (st.hasMoreTokens()) {
                throw new IllegalArgumentException(errMsg);
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    private void _verifyTokenValue(String token, String expected, String errMsg) {
        if (!token.equals(expected)) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    private void _setNumericFields() {
        try {
            this._iYear = Integer.parseInt(this._year);
            this._iMonths = Integer.parseInt(this._months);
            this._iDays = Integer.parseInt(this._days);
            this._iHours = Integer.parseInt(this._hours);
            this._iMinutes = Integer.parseInt(this._minutes);
            this._iSeconds = Integer.parseInt(this._seconds);
            if (this._fractionalSeconds != null) {
                this._iFractionalSeconds = Double.parseDouble("0." + this._fractionalSeconds);
            }
            if (this._hoursTimezone != null) {
                this._iHoursTimezone = Integer.parseInt(this._hoursTimezone);
            }
            if (this._minutesTimezone != null) {
                this._iMinutesTimezone = Integer.parseInt(this._minutesTimezone);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("All fields must be numbers: " + this._dateTimeString);
        }
    }

    private void _validateFieldValues() {
        if (this._year.length() < 4) {
            throw new IllegalArgumentException("Year field requires at least 4 digits: " + this._dateTimeString);
        }
        if (this._months.length() != 2) {
            throw new IllegalArgumentException("Month field must be two digits: " + this._dateTimeString);
        }
        if (this._days.length() != 2) {
            throw new IllegalArgumentException("Days field must be two digits: " + this._dateTimeString);
        }
        if (this._hours.length() != 2) {
            throw new IllegalArgumentException("Hours field must be two digits: " + this._dateTimeString);
        }
        if (this._minutes.length() != 2) {
            throw new IllegalArgumentException("Minutes field must be two digits: " + this._dateTimeString);
        }
        if (this._seconds.length() != 2) {
            throw new IllegalArgumentException("Seconds field must be two digits: " + this._dateTimeString);
        }
        if (this._hoursTimezone != null) {
            if (this._hoursTimezone.length() != 2) {
                throw new IllegalArgumentException("Timezone-hours field must be two digits: " + this._dateTimeString);
            }
            if (this._minutesTimezone.length() != 2) {
                throw new IllegalArgumentException("Timezone-minutes field must be two digits: " + this._dateTimeString);
            }
        }
        if (this._year.length() > 4 && this._year.charAt(0) == '0') {
            throw new IllegalArgumentException("Leading zeros in years with more than 4 digits are prohibited: " + this._dateTimeString);
        }
        if (this._iYear == 0) {
            throw new IllegalArgumentException("0000 is not a valid year: " + this._dateTimeString);
        }
        if (this._iHours > 24) {
            throw new IllegalArgumentException("Invalid hour value: " + this._dateTimeString);
        }
        if (this._iMinutes > 59) {
            throw new IllegalArgumentException("Invalid minute value: " + this._dateTimeString);
        }
        if (this._iSeconds > 59) {
            throw new IllegalArgumentException("Invalid second value: " + this._dateTimeString);
        }
        if (this._iHours == 24 && (this._iMinutes != 0 || this._iSeconds != 0)) {
            throw new IllegalArgumentException("Invalid time: " + this._dateTimeString);
        }
        if (this._iHoursTimezone > 14 || this._iMinutesTimezone > 59 || this._iHoursTimezone == 14 && this._iMinutesTimezone != 0) {
            throw new IllegalArgumentException("Invalid timezone: " + this._dateTimeString);
        }
    }

    public boolean isNormalized() {
        return this._isNormalized;
    }

    public void normalize() {
        if (this._isNormalized) {
            return;
        }
        if (this._iHours == 24 || this._hoursTimezone != null && (this._iHoursTimezone != 0 || this._iMinutesTimezone != 0)) {
            GregorianCalendar cal = new GregorianCalendar(this._iYear, this._iMonths - 1, this._iDays, this._iHours, this._iMinutes, this._iSeconds);
            if (this._isNegativeYear) {
                cal.set(0, 0);
            }
            if (this._isNegativeTimezone) {
                ((Calendar)cal).add(11, this._iHoursTimezone);
                ((Calendar)cal).add(12, this._iMinutesTimezone);
            } else {
                ((Calendar)cal).add(11, -this._iHoursTimezone);
                ((Calendar)cal).add(12, -this._iMinutesTimezone);
            }
            if (cal.get(0) == 0) {
                this._isNegativeYear = true;
            }
            this._iYear = cal.get(1);
            this._iMonths = cal.get(2) + 1;
            this._iDays = cal.get(5);
            this._iHours = cal.get(11);
            this._iMinutes = cal.get(12);
            this._iSeconds = cal.get(13);
            this._year = this._int2string(this._iYear, 4);
            this._months = this._int2string(this._iMonths, 2);
            this._days = this._int2string(this._iDays, 2);
            this._hours = this._int2string(this._iHours, 2);
            this._minutes = this._int2string(this._iMinutes, 2);
            this._seconds = this._int2string(this._iSeconds, 2);
            if (this._hoursTimezone != null) {
                this._iMinutesTimezone = 0;
                this._iHoursTimezone = 0;
                this._minutesTimezone = "00";
                this._hoursTimezone = "00";
                this._isNegativeTimezone = false;
            }
        }
        if (this._fractionalSeconds != null) {
            int zeroCount = 0;
            for (int i = this._fractionalSeconds.length() - 1; i >= 0 && this._fractionalSeconds.charAt(i) == '0'; --i) {
                ++zeroCount;
            }
            if (zeroCount == this._fractionalSeconds.length()) {
                this._fractionalSeconds = null;
            } else if (zeroCount > 0) {
                this._fractionalSeconds = this._fractionalSeconds.substring(0, this._fractionalSeconds.length() - zeroCount);
            }
        }
        this._isNormalized = true;
    }

    private String _int2string(int iValue, int minDigits) {
        String result = String.valueOf(iValue);
        int zeroCount = minDigits - result.length();
        if (zeroCount > 0) {
            StringBuffer buf = new StringBuffer(minDigits);
            for (int i = 0; i < zeroCount; ++i) {
                buf.append('0');
            }
            buf.append(result);
            result = buf.toString();
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(32);
        if (this._isNegativeYear) {
            result.append('-');
        }
        result.append(this._year);
        result.append('-');
        result.append(this._months);
        result.append('-');
        result.append(this._days);
        result.append('T');
        result.append(this._hours);
        result.append(':');
        result.append(this._minutes);
        result.append(':');
        result.append(this._seconds);
        if (this._fractionalSeconds != null) {
            result.append('.');
            result.append(this._fractionalSeconds);
        }
        if (this._hoursTimezone != null) {
            if (this._iHoursTimezone == 0 && this._iMinutesTimezone == 0) {
                result.append("Z");
            } else {
                if (this._isNegativeTimezone) {
                    result.append('-');
                } else {
                    result.append('+');
                }
                result.append(this._hoursTimezone);
                result.append(':');
                result.append(this._minutesTimezone);
            }
        }
        return result.toString();
    }

    public int compareTo(Object other) {
        DateTime thisDT = this;
        DateTime otherDT = (DateTime)other;
        if (thisDT._hoursTimezone != null && (thisDT._iHoursTimezone != 0 || thisDT._iMinutesTimezone != 0)) {
            thisDT = (DateTime)thisDT.clone();
            thisDT.normalize();
        }
        if (otherDT._hoursTimezone != null && (otherDT._iHoursTimezone != 0 || otherDT._iMinutesTimezone != 0)) {
            otherDT = (DateTime)otherDT.clone();
            otherDT.normalize();
        }
        if (thisDT._isNegativeYear && !otherDT._isNegativeYear) {
            return -1;
        }
        if (!thisDT._isNegativeYear && otherDT._isNegativeYear) {
            return 1;
        }
        int result = 0;
        if (thisDT._iYear != otherDT._iYear) {
            result = thisDT._iYear - otherDT._iYear;
        } else if (thisDT._iMonths != otherDT._iMonths) {
            result = thisDT._iMonths - otherDT._iMonths;
        } else if (thisDT._iDays != otherDT._iDays) {
            result = thisDT._iDays - otherDT._iDays;
        } else if (thisDT._iHours != otherDT._iHours) {
            result = thisDT._iHours - otherDT._iHours;
        } else if (thisDT._iMinutes != otherDT._iMinutes) {
            result = thisDT._iMinutes - otherDT._iMinutes;
        } else if (thisDT._iSeconds != otherDT._iSeconds) {
            result = thisDT._iSeconds - otherDT._iSeconds;
        } else if (thisDT._iFractionalSeconds != otherDT._iFractionalSeconds) {
            int n = result = thisDT._iFractionalSeconds < otherDT._iFractionalSeconds ? -1 : 1;
        }
        if (thisDT._isNegativeYear) {
            result = -result;
        }
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

