/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserSearchFeaturedType;
import org.fao.geonet.domain.converter.UserSearchFeaturedTypeConverter;
import org.fao.geonet.entitylistener.UserSearchEntityListenerManager;
import org.hibernate.annotations.Type;

@Entity
@Table(name="UserSearch")
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={UserSearchEntityListenerManager.class})
@SequenceGenerator(name="user_search_id_seq", initialValue=100, allocationSize=1)
public class UserSearch
extends Localized
implements Serializable {
    static final String ID_SEQ_NAME = "user_search_id_seq";
    public static final long serialVersionUID = 8189762204841260782L;
    private int id;
    private String url;
    private UserSearchFeaturedType featuredType;
    private Date creationDate;
    private User creator;
    private String logo;
    private Set<Group> groups = new HashSet<Group>();

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="user_search_id_seq")
    public int getId() {
        return this.id;
    }

    @Lob
    @Type(type="org.hibernate.type.TextType")
    public String getUrl() {
        return this.url;
    }

    @Column
    @Convert(converter=UserSearchFeaturedTypeConverter.class)
    public UserSearchFeaturedType getFeaturedType() {
        return this.featuredType;
    }

    @Transient
    public boolean isFeatured() {
        return this.featuredType != null;
    }

    @Column
    public Date getCreationDate() {
        return this.creationDate;
    }

    @ManyToOne
    @Nullable
    @JoinColumn(name="creator_id", referencedColumnName="id")
    public User getCreator() {
        return this.creator;
    }

    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinTable(name="usersearch_group", joinColumns={@JoinColumn(name="usersearch_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    public Set<Group> getGroups() {
        return this.groups;
    }

    @Column
    @Nullable
    public String getLogo() {
        return this.logo;
    }

    public UserSearch setId(int id) {
        this.id = id;
        return this;
    }

    public UserSearch setUrl(String url) {
        this.url = url;
        return this;
    }

    public UserSearch setFeaturedType(UserSearchFeaturedType featuredType) {
        this.featuredType = featuredType;
        return this;
    }

    public UserSearch setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    public UserSearch setCreator(User creator) {
        this.creator = creator;
        return this;
    }

    public UserSearch setLogo(String logo) {
        this.logo = logo;
        return this;
    }

    public UserSearch setGroups(Set<Group> groups) {
        this.groups = groups;
        return this;
    }

    @Override
    @ElementCollection(fetch=FetchType.LAZY, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="UserSearchDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false)
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSearch that = (UserSearch)o;
        return this.id == that.id && this.url.equals(that.url) && this.featuredType == that.featuredType && this.creationDate.equals(that.creationDate) && this.creator.equals(that.creator) && Objects.equals(this.logo, that.logo) && Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.url, this.featuredType, this.creationDate, this.creator, this.logo, this.groups});
    }

    public String toString() {
        return String.format("Entity of type %s with id: %d", this.getClass().getName(), this.getId());
    }
}

