/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.Schematron;
import org.fao.geonet.domain.SchematronCriteria;
import org.fao.geonet.domain.SchematronCriteriaGroupId;
import org.fao.geonet.domain.SchematronRequirement;

@Entity
@Table(name="SchematronCriteriaGroup")
@Access(value=AccessType.PROPERTY)
public class SchematronCriteriaGroup
extends GeonetEntity {
    private SchematronCriteriaGroupId id;
    private List<SchematronCriteria> criteria = new ArrayList<SchematronCriteria>();
    private SchematronRequirement requirement;
    private Schematron schematron;

    @EmbeddedId
    public SchematronCriteriaGroupId getId() {
        return this.id;
    }

    public SchematronCriteriaGroup setId(SchematronCriteriaGroupId id) {
        this.id = id;
        return this;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="group", orphanRemoval=true)
    public List<SchematronCriteria> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List<SchematronCriteria> criteria) {
        this.criteria = criteria;
    }

    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    public SchematronRequirement getRequirement() {
        return this.requirement;
    }

    public SchematronCriteriaGroup setRequirement(SchematronRequirement requirement) {
        this.requirement = requirement;
        return this;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="schematronId", nullable=false, updatable=false, insertable=false)
    public Schematron getSchematron() {
        return this.schematron;
    }

    public SchematronCriteriaGroup setSchematron(Schematron schematron) {
        this.schematron = schematron;
        if (schematron != null) {
            SchematronCriteriaGroupId id = this.getId();
            if (id == null) {
                id = new SchematronCriteriaGroupId();
                this.setId(id);
            }
            id.setSchematronId(schematron.getId());
        }
        return this;
    }

    public SchematronCriteriaGroup addCriteria(SchematronCriteria schematronCriteria) {
        schematronCriteria.setGroup(this);
        this.getCriteria().add(schematronCriteria);
        return this;
    }
}

