/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.bucket.geogrid.CellValues;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GeoTileCellIdSource
extends ValuesSource.Numeric {
    private final ValuesSource.GeoPoint valuesSource;
    private final int precision;
    private final GeoBoundingBox geoBoundingBox;

    public GeoTileCellIdSource(ValuesSource.GeoPoint valuesSource, int precision, GeoBoundingBox geoBoundingBox) {
        this.valuesSource = valuesSource;
        this.precision = precision;
        this.geoBoundingBox = geoBoundingBox;
    }

    public int precision() {
        return this.precision;
    }

    @Override
    public boolean isFloatingPoint() {
        return false;
    }

    @Override
    public SortedNumericDocValues longValues(LeafReaderContext ctx) {
        return this.geoBoundingBox.isUnbounded() ? new UnboundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision) : new BoundedCellValues(this.valuesSource.geoPointValues(ctx), this.precision, this.geoBoundingBox);
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
        throw new UnsupportedOperationException();
    }

    private static class UnboundedCellValues
    extends CellValues {
        UnboundedCellValues(MultiGeoPointValues geoValues, int precision) {
            super(geoValues, precision);
        }

        @Override
        int advanceValue(GeoPoint target, int valuesIdx) {
            this.values[valuesIdx] = GeoTileUtils.longEncode(target.getLon(), target.getLat(), this.precision);
            return valuesIdx + 1;
        }
    }

    private static class BoundedCellValues
    extends CellValues {
        private final boolean crossesDateline;
        private final long tiles;
        private final int minX;
        private final int maxX;
        private final int minY;
        private final int maxY;

        protected BoundedCellValues(MultiGeoPointValues geoValues, int precision, GeoBoundingBox bbox) {
            super(geoValues, precision);
            this.crossesDateline = bbox.right() < bbox.left();
            this.tiles = 1L << precision;
            int minX = GeoTileUtils.getXTile(bbox.left(), this.tiles);
            int minY = GeoTileUtils.getYTile(bbox.top(), this.tiles);
            Rectangle minTile = GeoTileUtils.toBoundingBox(minX, minY, precision);
            this.minX = minTile.getMaxX() == bbox.left() ? minX + 1 : minX;
            this.minY = minTile.getMinY() == bbox.top() ? minY + 1 : minY;
            int maxX = GeoTileUtils.getXTile(bbox.right(), this.tiles);
            int maxY = GeoTileUtils.getYTile(bbox.bottom(), this.tiles);
            Rectangle maxTile = GeoTileUtils.toBoundingBox(maxX, maxY, precision);
            this.maxX = maxTile.getMinX() == bbox.right() ? maxX - 1 : maxX;
            this.maxY = maxTile.getMaxY() == bbox.bottom() ? maxY - 1 : maxY;
        }

        @Override
        int advanceValue(GeoPoint target, int valuesIdx) {
            int y;
            int x = GeoTileUtils.getXTile(target.getLon(), this.tiles);
            if (this.validTile(x, y = GeoTileUtils.getYTile(target.getLat(), this.tiles))) {
                this.values[valuesIdx] = GeoTileUtils.longEncodeTiles(this.precision, x, y);
                return valuesIdx + 1;
            }
            return valuesIdx;
        }

        private boolean validTile(int x, int y) {
            if (this.maxY >= y && this.minY <= y) {
                if (this.crossesDateline) {
                    return this.maxX >= x || this.minX <= x;
                }
                return this.maxX >= x && this.minX <= x;
            }
            return false;
        }
    }
}

