/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.script.Converter;
import org.elasticsearch.script.Field;
import org.elasticsearch.script.FieldValues;
import org.elasticsearch.script.InvalidConversion;
import org.elasticsearch.script.JodaCompatibleZonedDateTime;

public class Converters {
    static final Converter<BigInteger, Field.BigIntegerField> BIGINTEGER = new Converter<BigInteger, Field.BigIntegerField>(){

        @Override
        public Field.BigIntegerField convert(Field<?> sourceField) {
            if (sourceField instanceof Field.LongField) {
                return Converters.LongToBigInteger((Field.LongField)sourceField);
            }
            if (sourceField instanceof Field.DoubleField) {
                return Converters.DoubleToBigInteger((Field.DoubleField)sourceField);
            }
            if (sourceField instanceof Field.StringField) {
                return Converters.StringToBigInteger((Field.StringField)sourceField);
            }
            if (sourceField instanceof Field.DateMillisField) {
                return Converters.LongToBigInteger(Converters.DateMillisToLong((Field.DateMillisField)sourceField));
            }
            if (sourceField instanceof Field.DateNanosField) {
                return Converters.LongToBigInteger(Converters.DateNanosToLong((Field.DateNanosField)sourceField));
            }
            if (sourceField instanceof Field.BooleanField) {
                return Converters.LongToBigInteger(Converters.BooleanToLong((Field.BooleanField)sourceField));
            }
            throw new InvalidConversion(sourceField.getClass(), this.getFieldClass());
        }

        @Override
        public Class<Field.BigIntegerField> getFieldClass() {
            return Field.BigIntegerField.class;
        }

        @Override
        public Class<BigInteger> getTargetClass() {
            return BigInteger.class;
        }
    };
    static final Converter<Long, Field.LongField> LONG = new Converter<Long, Field.LongField>(){

        @Override
        public Field.LongField convert(Field<?> sourceField) {
            if (sourceField instanceof Field.DoubleField) {
                return Converters.DoubleToLong((Field.DoubleField)sourceField);
            }
            if (sourceField instanceof Field.StringField) {
                return Converters.StringToLong((Field.StringField)sourceField);
            }
            if (sourceField instanceof Field.DateMillisField) {
                return Converters.DateMillisToLong((Field.DateMillisField)sourceField);
            }
            if (sourceField instanceof Field.DateNanosField) {
                return Converters.DateNanosToLong((Field.DateNanosField)sourceField);
            }
            if (sourceField instanceof Field.BigIntegerField) {
                return Converters.BigIntegerToLong((Field.BigIntegerField)sourceField);
            }
            if (sourceField instanceof Field.BooleanField) {
                return Converters.BooleanToLong((Field.BooleanField)sourceField);
            }
            throw new InvalidConversion(sourceField.getClass(), this.getFieldClass());
        }

        @Override
        public Class<Field.LongField> getFieldClass() {
            return Field.LongField.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.class;
        }
    };

    private Converters() {
    }

    static Field.BigIntegerField LongToBigInteger(Field.LongField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.BigIntegerField(sourceField.getName(), (FieldValues<BigInteger>)new DelegatingFieldValues<BigInteger, Long>(fv){

            @Override
            public List<BigInteger> getValues() {
                return this.values.getValues().stream().map(BigInteger::valueOf).collect(Collectors.toList());
            }

            @Override
            public BigInteger getNonPrimitiveValue() {
                return BigInteger.valueOf(this.values.getLongValue());
            }
        });
    }

    static Field.BigIntegerField DoubleToBigInteger(Field.DoubleField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.BigIntegerField(sourceField.getName(), (FieldValues<BigInteger>)new DelegatingFieldValues<BigInteger, Double>(fv){

            @Override
            public List<BigInteger> getValues() {
                return this.values.getValues().stream().map(dbl -> BigInteger.valueOf(dbl.longValue())).collect(Collectors.toList());
            }

            @Override
            public BigInteger getNonPrimitiveValue() {
                return BigInteger.valueOf(this.values.getLongValue());
            }
        });
    }

    static Field.BigIntegerField StringToBigInteger(Field.StringField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.BigIntegerField(sourceField.getName(), (FieldValues<BigInteger>)new DelegatingFieldValues<BigInteger, String>(fv){

            protected BigInteger parseNumber(String str) {
                try {
                    return new BigInteger(str);
                }
                catch (NumberFormatException e) {
                    return new BigDecimal(str).toBigInteger();
                }
            }

            @Override
            public List<BigInteger> getValues() {
                return this.values.getValues().stream().map(this::parseNumber).collect(Collectors.toList());
            }

            @Override
            public BigInteger getNonPrimitiveValue() {
                return this.parseNumber((String)this.values.getNonPrimitiveValue());
            }
        });
    }

    static Field.LongField BigIntegerToLong(Field.BigIntegerField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.LongField(sourceField.getName(), (FieldValues<Long>)new DelegatingFieldValues<Long, BigInteger>(fv){

            @Override
            public List<Long> getValues() {
                return this.values.getValues().stream().map(BigInteger::longValue).collect(Collectors.toList());
            }

            @Override
            public Long getNonPrimitiveValue() {
                return this.values.getLongValue();
            }
        });
    }

    static Field.LongField BooleanToLong(Field.BooleanField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.LongField(sourceField.getName(), (FieldValues<Long>)new DelegatingFieldValues<Long, Boolean>(fv){

            @Override
            public List<Long> getValues() {
                return this.values.getValues().stream().map(bool -> bool != false ? 1L : 0L).collect(Collectors.toList());
            }

            @Override
            public Long getNonPrimitiveValue() {
                return this.getLongValue();
            }
        });
    }

    static Field.LongField DateMillisToLong(Field.DateMillisField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.LongField(sourceField.getName(), (FieldValues<Long>)new DelegatingFieldValues<Long, JodaCompatibleZonedDateTime>(fv){

            @Override
            public List<Long> getValues() {
                return this.values.getValues().stream().map(dt -> dt.toInstant().toEpochMilli()).collect(Collectors.toList());
            }

            @Override
            public Long getNonPrimitiveValue() {
                return ((JodaCompatibleZonedDateTime)this.values.getNonPrimitiveValue()).toInstant().toEpochMilli();
            }
        });
    }

    static Field.LongField DateNanosToLong(Field.DateNanosField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.LongField(sourceField.getName(), (FieldValues<Long>)new DelegatingFieldValues<Long, JodaCompatibleZonedDateTime>(fv){

            protected long nanoLong(JodaCompatibleZonedDateTime dt) {
                return ChronoUnit.NANOS.between(Instant.EPOCH, dt.toInstant());
            }

            @Override
            public List<Long> getValues() {
                return this.values.getValues().stream().map(this::nanoLong).collect(Collectors.toList());
            }

            @Override
            public Long getNonPrimitiveValue() {
                return ChronoUnit.NANOS.between(Instant.EPOCH, ((JodaCompatibleZonedDateTime)this.values.getNonPrimitiveValue()).toInstant());
            }
        });
    }

    static Field.LongField DoubleToLong(Field.DoubleField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.LongField(sourceField.getName(), (FieldValues<Long>)new DelegatingFieldValues<Long, Double>(fv){

            @Override
            public List<Long> getValues() {
                return this.values.getValues().stream().map(Double::longValue).collect(Collectors.toList());
            }

            @Override
            public Long getNonPrimitiveValue() {
                return this.values.getLongValue();
            }
        });
    }

    static Field.LongField StringToLong(Field.StringField sourceField) {
        FieldValues fv = sourceField.getFieldValues();
        return new Field.LongField(sourceField.getName(), (FieldValues<Long>)new DelegatingFieldValues<Long, String>(fv){

            @Override
            public List<Long> getValues() {
                return this.values.getValues().stream().map(Long::parseLong).collect(Collectors.toList());
            }

            @Override
            public Long getNonPrimitiveValue() {
                return Long.parseLong((String)this.values.getNonPrimitiveValue());
            }

            @Override
            public long getLongValue() {
                return Long.parseLong((String)this.values.getNonPrimitiveValue());
            }

            @Override
            public double getDoubleValue() {
                return this.getLongValue();
            }
        });
    }

    public static abstract class DelegatingFieldValues<T, D>
    implements FieldValues<T> {
        protected FieldValues<D> values;

        public DelegatingFieldValues(FieldValues<D> values) {
            this.values = values;
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public long getLongValue() {
            return this.values.getLongValue();
        }

        @Override
        public double getDoubleValue() {
            return this.values.getDoubleValue();
        }
    }
}

