/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Set;
import org.elasticsearch.core.List;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.SourceLookup;

public abstract class ArraySourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;

    public ArraySourceValueFetcher(String fieldName, SearchExecutionContext context) {
        this(fieldName, context, null);
    }

    public ArraySourceValueFetcher(String fieldName, SearchExecutionContext context, Object nullValue) {
        this.sourcePaths = context.sourcePath(fieldName);
        this.nullValue = nullValue;
    }

    @Override
    public java.util.List<Object> fetchValues(SourceLookup lookup) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = lookup.extractValue(path, this.nullValue);
            if (sourceValue == null) {
                return List.of();
            }
            try {
                values.addAll((java.util.List)this.parseSourceValue(sourceValue));
            }
            catch (Exception exception) {}
        }
        return values;
    }

    protected abstract Object parseSourceValue(Object var1);
}

