/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.text.ParseException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoJson;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownText;

public enum GeometryParserFormat {
    WKT{

        @Override
        public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (geometry != null) {
                return builder.value(WellKnownText.toWKT((Geometry)geometry));
            }
            return builder.nullValue();
        }

        @Override
        public Geometry fromXContent(GeometryValidator validator, boolean coerce, boolean rightOrientation, XContentParser parser) throws IOException, ParseException {
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            return WellKnownText.fromWKT((GeometryValidator)validator, (boolean)coerce, (String)parser.text());
        }
    }
    ,
    GEOJSON{

        @Override
        public XContentBuilder toXContent(Geometry geometry, XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (geometry != null) {
                return GeoJson.toXContent(geometry, builder, params);
            }
            return builder.nullValue();
        }

        @Override
        public Geometry fromXContent(GeometryValidator validator, boolean coerce, boolean rightOrientation, XContentParser parser) throws IOException, ParseException {
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            return GeoJson.fromXContent(validator, coerce, rightOrientation, parser);
        }
    };


    public abstract XContentBuilder toXContent(Geometry var1, XContentBuilder var2, ToXContent.Params var3) throws IOException;

    public abstract Geometry fromXContent(GeometryValidator var1, boolean var2, boolean var3, XContentParser var4) throws IOException, ParseException;

    public static GeometryParserFormat geometryFormat(XContentParser parser) {
        switch (parser.currentToken()) {
            case START_OBJECT: 
            case VALUE_NULL: {
                return GEOJSON;
            }
            case VALUE_STRING: {
                return WKT;
            }
        }
        throw new ElasticsearchParseException("shape must be an object consisting of type and coordinates", new Object[0]);
    }
}

