/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.ShardsAcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class RolloverResponse
extends ShardsAcknowledgedResponse
implements ToXContentObject {
    private static final ParseField NEW_INDEX = new ParseField("new_index", new String[0]);
    private static final ParseField OLD_INDEX = new ParseField("old_index", new String[0]);
    private static final ParseField DRY_RUN = new ParseField("dry_run", new String[0]);
    private static final ParseField ROLLED_OVER = new ParseField("rolled_over", new String[0]);
    private static final ParseField CONDITIONS = new ParseField("conditions", new String[0]);
    private static final ConstructingObjectParser<RolloverResponse, Void> PARSER = new ConstructingObjectParser("rollover", true, args -> new RolloverResponse((String)args[0], (String)args[1], (Map)args[2], (Boolean)args[3], (Boolean)args[4], (Boolean)args[5], (Boolean)args[6]));
    private final String oldIndex;
    private final String newIndex;
    private final Map<String, Boolean> conditionStatus;
    private final boolean dryRun;
    private final boolean rolledOver;
    private final boolean shardsAcknowledged;

    RolloverResponse(StreamInput in) throws IOException {
        super(in, false, in.getVersion().onOrAfter(Version.V_6_4_0));
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.oldIndex = in.readString();
            this.newIndex = in.readString();
            int conditionSize = in.readVInt();
            this.conditionStatus = new HashMap<String, Boolean>(conditionSize);
            for (int i = 0; i < conditionSize; ++i) {
                this.conditionStatus.put(in.readString(), in.readBoolean());
            }
            this.dryRun = in.readBoolean();
            this.rolledOver = in.readBoolean();
            this.shardsAcknowledged = in.readBoolean();
        } else {
            this.oldIndex = in.readString();
            this.newIndex = in.readString();
            int conditionSize = in.readVInt();
            this.conditionStatus = new HashMap<String, Boolean>(conditionSize);
            for (int i = 0; i < conditionSize; ++i) {
                this.conditionStatus.put(in.readString(), in.readBoolean());
            }
            this.dryRun = in.readBoolean();
            this.rolledOver = in.readBoolean();
            this.acknowledged = in.readBoolean();
            this.shardsAcknowledged = in.readBoolean();
        }
    }

    public RolloverResponse(String oldIndex, String newIndex, Map<String, Boolean> conditionResults, boolean dryRun, boolean rolledOver, boolean acknowledged, boolean shardsAcknowledged) {
        super(acknowledged, shardsAcknowledged);
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.dryRun = dryRun;
        this.rolledOver = rolledOver;
        this.conditionStatus = conditionResults;
        this.shardsAcknowledged = shardsAcknowledged;
    }

    public String getOldIndex() {
        return this.oldIndex;
    }

    public String getNewIndex() {
        return this.newIndex;
    }

    public Map<String, Boolean> getConditionStatus() {
        return this.conditionStatus;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isRolledOver() {
        return this.rolledOver;
    }

    @Override
    public boolean isShardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            super.writeTo(out);
            out.writeString(this.oldIndex);
            out.writeString(this.newIndex);
            out.writeVInt(this.conditionStatus.size());
            for (Map.Entry<String, Boolean> entry : this.conditionStatus.entrySet()) {
                out.writeString(entry.getKey());
                out.writeBoolean(entry.getValue());
            }
            out.writeBoolean(this.dryRun);
            out.writeBoolean(this.rolledOver);
            out.writeBoolean(this.shardsAcknowledged);
        } else {
            out.writeString(this.oldIndex);
            out.writeString(this.newIndex);
            out.writeVInt(this.conditionStatus.size());
            for (Map.Entry<String, Boolean> entry : this.conditionStatus.entrySet()) {
                out.writeString(entry.getKey());
                out.writeBoolean(entry.getValue());
            }
            out.writeBoolean(this.dryRun);
            out.writeBoolean(this.rolledOver);
            out.writeBoolean(this.acknowledged);
            this.writeShardsAcknowledged(out);
        }
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.field(OLD_INDEX.getPreferredName(), this.oldIndex);
        builder.field(NEW_INDEX.getPreferredName(), this.newIndex);
        builder.field(ROLLED_OVER.getPreferredName(), this.rolledOver);
        builder.field(DRY_RUN.getPreferredName(), this.dryRun);
        builder.startObject(CONDITIONS.getPreferredName());
        for (Map.Entry<String, Boolean> entry : this.conditionStatus.entrySet()) {
            builder.field(entry.getKey(), entry.getValue());
        }
        builder.endObject();
    }

    public static RolloverResponse fromXContent(XContentParser parser) {
        return (RolloverResponse)PARSER.apply(parser, null);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            RolloverResponse that = (RolloverResponse)o;
            return this.dryRun == that.dryRun && this.rolledOver == that.rolledOver && Objects.equals(this.oldIndex, that.oldIndex) && Objects.equals(this.newIndex, that.newIndex) && Objects.equals(this.conditionStatus, that.conditionStatus);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.oldIndex, this.newIndex, this.conditionStatus, this.dryRun, this.rolledOver);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.text(), OLD_INDEX, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.text(), NEW_INDEX, ObjectParser.ValueType.STRING);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.map(), CONDITIONS);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), DRY_RUN, ObjectParser.ValueType.BOOLEAN);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.booleanValue(), ROLLED_OVER, ObjectParser.ValueType.BOOLEAN);
        RolloverResponse.declareAcknowledgedAndShardsAcknowledgedFields(PARSER);
    }
}

