/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.ingest.IngestInfo;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.search.aggregations.support.AggregationInfo;
import org.elasticsearch.threadpool.ThreadPoolInfo;
import org.elasticsearch.transport.TransportInfo;

public class NodeInfo
extends BaseNodeResponse {
    private Version version;
    private Build build;
    @Nullable
    private Settings settings;
    private Map<Class<? extends ReportingService.Info>, ReportingService.Info> infoMap = new HashMap<Class<? extends ReportingService.Info>, ReportingService.Info>();
    @Nullable
    private ByteSizeValue totalIndexingBuffer;

    public NodeInfo(StreamInput in) throws IOException {
        super(in);
        this.version = Version.readVersion(in);
        this.build = Build.readBuild(in);
        this.totalIndexingBuffer = in.readBoolean() ? new ByteSizeValue(in.readLong()) : null;
        if (in.readBoolean()) {
            this.settings = Settings.readSettingsFromStream(in);
        }
        this.addInfoIfNonNull(OsInfo.class, in.readOptionalWriteable(OsInfo::new));
        this.addInfoIfNonNull(ProcessInfo.class, in.readOptionalWriteable(ProcessInfo::new));
        this.addInfoIfNonNull(JvmInfo.class, in.readOptionalWriteable(JvmInfo::new));
        this.addInfoIfNonNull(ThreadPoolInfo.class, in.readOptionalWriteable(ThreadPoolInfo::new));
        this.addInfoIfNonNull(TransportInfo.class, in.readOptionalWriteable(TransportInfo::new));
        this.addInfoIfNonNull(HttpInfo.class, in.readOptionalWriteable(HttpInfo::new));
        this.addInfoIfNonNull(PluginsAndModules.class, in.readOptionalWriteable(PluginsAndModules::new));
        this.addInfoIfNonNull(IngestInfo.class, in.readOptionalWriteable(IngestInfo::new));
        if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.addInfoIfNonNull(AggregationInfo.class, in.readOptionalWriteable(AggregationInfo::new));
        }
    }

    public NodeInfo(Version version, Build build, DiscoveryNode node, @Nullable Settings settings, @Nullable OsInfo os, @Nullable ProcessInfo process, @Nullable JvmInfo jvm, @Nullable ThreadPoolInfo threadPool, @Nullable TransportInfo transport, @Nullable HttpInfo http, @Nullable PluginsAndModules plugins, @Nullable IngestInfo ingest, @Nullable AggregationInfo aggsInfo, @Nullable ByteSizeValue totalIndexingBuffer) {
        super(node);
        this.version = version;
        this.build = build;
        this.settings = settings;
        this.addInfoIfNonNull(OsInfo.class, os);
        this.addInfoIfNonNull(ProcessInfo.class, process);
        this.addInfoIfNonNull(JvmInfo.class, jvm);
        this.addInfoIfNonNull(ThreadPoolInfo.class, threadPool);
        this.addInfoIfNonNull(TransportInfo.class, transport);
        this.addInfoIfNonNull(HttpInfo.class, http);
        this.addInfoIfNonNull(PluginsAndModules.class, plugins);
        this.addInfoIfNonNull(IngestInfo.class, ingest);
        this.addInfoIfNonNull(AggregationInfo.class, aggsInfo);
        this.totalIndexingBuffer = totalIndexingBuffer;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    public Version getVersion() {
        return this.version;
    }

    public Build getBuild() {
        return this.build;
    }

    @Nullable
    public Settings getSettings() {
        return this.settings;
    }

    public <T extends ReportingService.Info> T getInfo(Class<T> clazz) {
        return (T)((ReportingService.Info)clazz.cast(this.infoMap.get(clazz)));
    }

    @Nullable
    public ByteSizeValue getTotalIndexingBuffer() {
        return this.totalIndexingBuffer;
    }

    private <T extends ReportingService.Info> void addInfoIfNonNull(Class<T> clazz, T info) {
        if (info != null) {
            this.infoMap.put(clazz, info);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.version.id);
        Build.writeBuild(this.build, out);
        if (this.totalIndexingBuffer == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.totalIndexingBuffer.getBytes());
        }
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Settings.writeSettingsToStream(this.settings, out);
        }
        out.writeOptionalWriteable(this.getInfo(OsInfo.class));
        out.writeOptionalWriteable(this.getInfo(ProcessInfo.class));
        out.writeOptionalWriteable(this.getInfo(JvmInfo.class));
        out.writeOptionalWriteable(this.getInfo(ThreadPoolInfo.class));
        out.writeOptionalWriteable(this.getInfo(TransportInfo.class));
        out.writeOptionalWriteable(this.getInfo(HttpInfo.class));
        out.writeOptionalWriteable(this.getInfo(PluginsAndModules.class));
        out.writeOptionalWriteable(this.getInfo(IngestInfo.class));
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeOptionalWriteable(this.getInfo(AggregationInfo.class));
        }
    }
}

