/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ShortCollection;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.LongKeyShortMap;
import bak.pcj.map.LongKeyShortMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractLongKeyShortMap
implements LongKeyShortMap {
    protected AbstractLongKeyShortMap() {
    }

    public void clear() {
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public short remove(long key) {
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            short value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultShort();
    }

    public void putAll(LongKeyShortMap map) {
        LongKeyShortMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(long key) {
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public short get(long key) {
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultShort();
    }

    public boolean containsValue(short value) {
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongKeyShortMap)) {
            return false;
        }
        LongKeyShortMap map = (LongKeyShortMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            long k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultLongHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultShortHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public short tget(long key) {
        short value = this.get(key);
        if (value == MapDefaults.defaultShort() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        LongKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ShortCollection values();

    public abstract short put(long var1, short var3);

    public abstract short lget();

    public abstract LongSet keySet();

    public abstract LongKeyShortMapIterator entries();
}

