/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.SetToShortSetAdapter;
import bak.pcj.map.AbstractShortKeyMap;
import bak.pcj.map.ShortKeyMap;
import bak.pcj.map.ShortKeyMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MapToShortKeyMapAdapter
extends AbstractShortKeyMap
implements ShortKeyMap {
    protected Map map;

    public MapToShortKeyMapAdapter(Map map) {
        this(map, false);
    }

    public MapToShortKeyMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(short key) {
        return this.map.get(new Short(key)) != null;
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public ShortKeyMapIterator entries() {
        return new ShortKeyMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToShortKeyMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public short getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getKey();
            }

            public Object getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public Object get(short key) {
        return this.map.get(new Short(key));
    }

    public ShortSet keySet() {
        return new SetToShortSetAdapter(this.map.keySet());
    }

    public Object put(short key, Object value) {
        return this.map.put(new Short(key), value);
    }

    public Object remove(short key) {
        return this.map.remove(new Short(key));
    }

    public int size() {
        return this.map.size();
    }

    public Collection values() {
        return this.map.values();
    }

    public boolean validate() {
        return Adapter.isShortKeyAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

