/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ByteCollection;
import bak.pcj.adapter.CollectionToByteCollectionAdapter;
import bak.pcj.adapter.SetToFloatSetAdapter;
import bak.pcj.map.AbstractFloatKeyByteMap;
import bak.pcj.map.FloatKeyByteMap;
import bak.pcj.map.FloatKeyByteMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToFloatKeyByteMapAdapter
extends AbstractFloatKeyByteMap
implements FloatKeyByteMap {
    protected Map map;
    protected Byte lastValue;

    public MapToFloatKeyByteMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToFloatKeyByteMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(float key) {
        this.lastValue = (Byte)this.map.get(new Float(key));
        return this.lastValue != null;
    }

    public boolean containsValue(byte value) {
        return this.map.containsValue(new Byte(value));
    }

    public FloatKeyByteMapIterator entries() {
        return new FloatKeyByteMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToFloatKeyByteMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public float getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Float)this.lastEntry.getKey()).floatValue();
            }

            public byte getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public byte get(float key) {
        Byte value = (Byte)this.map.get(new Float(key));
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public FloatSet keySet() {
        return new SetToFloatSetAdapter(this.map.keySet());
    }

    public byte lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public byte put(float key, byte value) {
        Byte oldValue = this.map.put(new Float(key), new Byte(value));
        return oldValue == null ? MapDefaults.defaultByte() : oldValue;
    }

    public byte remove(float key) {
        Byte value = (Byte)this.map.remove(new Float(key));
        return value == null ? MapDefaults.defaultByte() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ByteCollection values() {
        return new CollectionToByteCollectionAdapter(this.map.values());
    }

    public byte tget(float key) {
        Byte value = (Byte)this.map.get(new Float(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isFloatKeyByteAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

