/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.LongCollection;
import bak.pcj.adapter.CollectionToLongCollectionAdapter;
import bak.pcj.adapter.SetToBooleanSetAdapter;
import bak.pcj.map.AbstractBooleanKeyLongMap;
import bak.pcj.map.BooleanKeyLongMap;
import bak.pcj.map.BooleanKeyLongMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.BooleanSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToBooleanKeyLongMapAdapter
extends AbstractBooleanKeyLongMap
implements BooleanKeyLongMap {
    protected Map map;
    protected Long lastValue;

    public MapToBooleanKeyLongMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToBooleanKeyLongMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(boolean key) {
        this.lastValue = (Long)this.map.get(new Boolean(key));
        return this.lastValue != null;
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(new Long(value));
    }

    public BooleanKeyLongMapIterator entries() {
        return new BooleanKeyLongMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToBooleanKeyLongMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public boolean getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getKey();
            }

            public long getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Long)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public long get(boolean key) {
        Long value = (Long)this.map.get(new Boolean(key));
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public BooleanSet keySet() {
        return new SetToBooleanSetAdapter(this.map.keySet());
    }

    public long lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public long put(boolean key, long value) {
        Long oldValue = this.map.put(new Boolean(key), new Long(value));
        return oldValue == null ? MapDefaults.defaultLong() : oldValue;
    }

    public long remove(boolean key) {
        Long value = (Long)this.map.remove(new Boolean(key));
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public int size() {
        return this.map.size();
    }

    public LongCollection values() {
        return new CollectionToLongCollectionAdapter(this.map.values());
    }

    public long tget(boolean key) {
        Long value = (Long)this.map.get(new Boolean(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isBooleanKeyLongAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

