/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.AbstractLongCollection;
import bak.pcj.Adapter;
import bak.pcj.LongIterator;
import bak.pcj.adapter.IteratorToLongIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.Collection;

public class CollectionToLongCollectionAdapter
extends AbstractLongCollection {
    protected Collection collection;

    public CollectionToLongCollectionAdapter(Collection collection) {
        this(collection, false);
    }

    public CollectionToLongCollectionAdapter(Collection collection, boolean validate) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(long v) {
        return this.collection.add(new Long(v));
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(long v) {
        return this.collection.contains(new Long(v));
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public LongIterator iterator() {
        return new IteratorToLongIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(long v) {
        return this.collection.remove(new Long(v));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean validate() {
        return Adapter.isLongAdaptable(this.collection);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("collection");
        }
    }
}

