/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.geotools.renderer.style.MarkFactory;
import org.geotools.renderer.util.ExplicitBoundsShape;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class ShapeMarkFactory
implements MarkFactory {
    private static final String SHAPE_PREFIX = "shape://";
    static Map<String, Shape> shapes = new HashMap<String, Shape>();

    @Override
    public Shape getShape(Graphics2D graphics, Expression symbolUrl, Feature feature) throws Exception {
        if (symbolUrl == null) {
            return null;
        }
        String wellKnownName = (String)symbolUrl.evaluate((Object)feature, String.class);
        if (!wellKnownName.startsWith(SHAPE_PREFIX)) {
            return null;
        }
        String name = wellKnownName.substring(SHAPE_PREFIX.length());
        return shapes.get(name);
    }

    static {
        shapes.put("vertline", new Line2D.Double(0.0, -0.5, 0.0, 0.5));
        shapes.put("horline", new Line2D.Double(-0.5, 0.0, 0.5, 0.0));
        shapes.put("slash", new Line2D.Double(-0.5, -0.5, 0.5, 0.5));
        shapes.put("backslash", new Line2D.Double(-0.5, 0.5, 0.5, -0.5));
        ExplicitBoundsShape dotShape = new ExplicitBoundsShape(new Ellipse2D.Double(-1.0E-6, -1.0E-6, 1.0E-6, 1.0E-6));
        dotShape.setBounds(new Rectangle2D.Double(-0.5, 0.5, 1.0, 1.0));
        shapes.put("dot", dotShape);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.0f);
        gp.lineTo(0.5f, 0.0f);
        gp.moveTo(0.0f, -0.5f);
        gp.lineTo(0.0f, 0.5f);
        shapes.put("plus", gp);
        gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.5f);
        gp.lineTo(0.5f, -0.5f);
        gp.moveTo(-0.5f, -0.5f);
        gp.lineTo(0.5f, 0.5f);
        shapes.put("times", gp);
        gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.2f);
        gp.lineTo(0.0f, 0.0f);
        gp.lineTo(-0.5f, -0.2f);
        ExplicitBoundsShape oarrow = new ExplicitBoundsShape(gp);
        oarrow.setBounds(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        shapes.put("oarrow", oarrow);
        gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.2f);
        gp.lineTo(0.0f, 0.0f);
        gp.lineTo(-0.5f, -0.2f);
        gp.closePath();
        ExplicitBoundsShape carrow = new ExplicitBoundsShape(gp);
        carrow.setBounds(new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0));
        shapes.put("carrow", carrow);
        gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.3f);
        gp.lineTo(0.5, 0.0);
        gp.lineTo(-0.5f, -0.3f);
        ExplicitBoundsShape coarrow = new ExplicitBoundsShape(gp);
        coarrow.setBounds(new Rectangle2D.Double(-0.5, -0.3, 1.0, 0.6));
        shapes.put("coarrow", coarrow);
        gp = new GeneralPath();
        gp.moveTo(-0.5f, 0.3f);
        gp.lineTo(0.5, 0.0);
        gp.lineTo(-0.5f, -0.3f);
        gp.closePath();
        ExplicitBoundsShape ccarrow = new ExplicitBoundsShape(gp);
        ccarrow.setBounds(new Rectangle2D.Double(-0.5, -0.3, 1.0, 0.6));
        shapes.put("ccarrow", ccarrow);
    }
}

