/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.filter.function.RenderingTransformation;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.FastBBOX;
import org.geotools.renderer.lite.RendererUtilities;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public abstract class RenderingTransformationHelper {
    private static final FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    public static final int TRANSFORM_READ_BUFFER_PIXELS = 10;

    public Object applyRenderingTransformation(Expression transformation, FeatureSource featureSource, Query layerQuery, Query renderingQuery, GridGeometry2D gridGeometry, CoordinateReferenceSystem sourceCrs, RenderingHints hints) throws IOException, SchemaException, TransformException, FactoryException {
        Object result = null;
        Object schema = featureSource.getSchema();
        boolean isRasterData = false;
        if (schema instanceof SimpleFeatureType) {
            SimpleFeatureType simpleSchema = (SimpleFeatureType)schema;
            GridCoverage2D coverage = null;
            if (FeatureUtilities.isWrappedCoverage((SimpleFeatureType)simpleSchema) || FeatureUtilities.isWrappedCoverageReader((SimpleFeatureType)simpleSchema)) {
                isRasterData = true;
                GridGeometry2D readGG = gridGeometry;
                if (transformation instanceof RenderingTransformation) {
                    RenderingTransformation tx = (RenderingTransformation)transformation;
                    readGG = (GridGeometry2D)tx.invertGridGeometry(renderingQuery, (GridGeometry)gridGeometry);
                }
                FeatureCollection sample = featureSource.getFeatures();
                Object gridWrapper = DataUtilities.first(sample);
                if (FeatureUtilities.isWrappedCoverageReader((SimpleFeatureType)simpleSchema)) {
                    MathTransform g2w;
                    GeneralParameterValue[] params = (GeneralParameterValue[])FeatureUtilities.PARAMS_PROPERTY_NAME.evaluate(gridWrapper, GeneralParameterValue[].class);
                    GridCoverage2DReader reader = (GridCoverage2DReader)FeatureUtilities.GRID_PROPERTY_NAME.evaluate(gridWrapper);
                    if (CRS.equalsIgnoreMetadata(reader.getCoordinateReferenceSystem(), gridGeometry.getCoordinateReferenceSystem()) && (g2w = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER)) instanceof AffineTransform2D && readGG.getGridToCRS2D() instanceof AffineTransform2D) {
                        AffineTransform2D atOriginal = (AffineTransform2D)g2w;
                        AffineTransform2D atMap = (AffineTransform2D)readGG.getGridToCRS2D();
                        if (XAffineTransform.getScale(atMap) < XAffineTransform.getScale(atOriginal)) {
                            org.opengis.geometry.Envelope worldEnvelope = gridGeometry.getEnvelope();
                            GeneralEnvelope transformed = CRS.transform((MathTransform)atOriginal.inverse(), worldEnvelope);
                            int minx = (int)Math.floor(transformed.getMinimum(0));
                            int miny = (int)Math.floor(transformed.getMinimum(1));
                            int maxx = (int)Math.ceil(transformed.getMaximum(0));
                            int maxy = (int)Math.ceil(transformed.getMaximum(1));
                            Rectangle rect = new Rectangle(minx - 10, miny - 10, maxx - minx + 20, maxy - miny + 20);
                            GridEnvelope2D gridEnvelope = new GridEnvelope2D(rect);
                            readGG = new GridGeometry2D((GridEnvelope)gridEnvelope, PixelInCell.CELL_CORNER, (MathTransform)atOriginal, worldEnvelope.getCoordinateReferenceSystem(), null);
                        }
                    }
                    if (transformation instanceof RenderingTransformation) {
                        RenderingTransformation tx = (RenderingTransformation)transformation;
                        params = tx.customizeReadParams((GridCoverageReader)reader, params);
                    }
                    coverage = this.readCoverage(reader, params, readGG);
                } else {
                    coverage = (GridCoverage2D)FeatureUtilities.GRID_PROPERTY_NAME.evaluate(gridWrapper);
                }
                if (coverage != null) {
                    if (readGG != null) {
                        MathTransform2D coverageTx;
                        ParameterValueGroup param;
                        GeographicBoundingBox crsLatLonBoundingBox;
                        ReferencedEnvelope renderingEnvelope = new ReferencedEnvelope(readGG.getEnvelope());
                        CoordinateReferenceSystem coverageCRS = coverage.getCoordinateReferenceSystem2D();
                        if (!CRS.equalsIgnoreMetadata(renderingEnvelope.getCoordinateReferenceSystem(), coverageCRS)) {
                            renderingEnvelope = renderingEnvelope.transform(coverageCRS, true);
                        }
                        if (null == (crsLatLonBoundingBox = CRS.getGeographicBoundingBox(coverageCRS)) || crsLatLonBoundingBox.getEastBoundLongitude() - crsLatLonBoundingBox.getWestBoundLongitude() >= 360.0) {
                            if (coverage.getEnvelope2D().contains(renderingEnvelope)) {
                                param = PROCESSOR.getOperation("CoverageCrop").getParameters();
                                param.parameter("Source").setValue((Object)coverage);
                                param.parameter("Envelope").setValue((Object)renderingEnvelope);
                                coverage = (GridCoverage2D)PROCESSOR.doOperation(param);
                            }
                        } else if (coverage.getEnvelope2D().intersects(renderingEnvelope)) {
                            param = PROCESSOR.getOperation("CoverageCrop").getParameters();
                            param.parameter("Source").setValue((Object)coverage);
                            param.parameter("Envelope").setValue((Object)renderingEnvelope);
                            coverage = (GridCoverage2D)PROCESSOR.doOperation(param);
                        } else {
                            coverage = null;
                        }
                        if (coverage != null && (coverageTx = readGG.getGridToCRS2D()) instanceof AffineTransform) {
                            AffineTransform coverageAt = (AffineTransform)coverageTx;
                            AffineTransform renderingAt = (AffineTransform)gridGeometry.getGridToCRS2D();
                            double ratioX = coverageAt.getScaleX() / renderingAt.getScaleX();
                            double ratioY = coverageAt.getScaleY() / renderingAt.getScaleY();
                            if (ratioX < 0.7 && ratioY < 0.7) {
                                ParameterValueGroup param2 = PROCESSOR.getOperation("Scale").getParameters();
                                param2.parameter("Source").setValue((Object)coverage);
                                param2.parameter("xScale").setValue(ratioX);
                                param2.parameter("yScale").setValue(ratioY);
                                Interpolation interpolation = (Interpolation)hints.get(JAI.KEY_INTERPOLATION);
                                if (interpolation != null) {
                                    param2.parameter("Interpolation").setValue((Object)interpolation);
                                }
                                coverage = (GridCoverage2D)PROCESSOR.doOperation(param2);
                            }
                        }
                    }
                    result = coverage != null ? transformation.evaluate((Object)coverage) : null;
                }
            }
        }
        if (result == null && !isRasterData) {
            Query optimizedQuery = null;
            if (transformation instanceof RenderingTransformation) {
                RenderingTransformation tx = (RenderingTransformation)transformation;
                optimizedQuery = tx.invertQuery(renderingQuery, (GridGeometry)gridGeometry);
            }
            if (optimizedQuery == null) {
                Envelope bounds = (Envelope)renderingQuery.getFilter().accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null);
                FastBBOX bbox = new FastBBOX(filterFactory.property(""), bounds, (FilterFactory)filterFactory);
                optimizedQuery = new Query(null, (Filter)bbox);
                optimizedQuery.setHints(layerQuery.getHints());
            }
            Query mixedQuery = DataUtilities.mixQueries(layerQuery, optimizedQuery, null);
            FeatureCollection originalFeatures = featureSource.getFeatures(mixedQuery);
            originalFeatures = RendererUtilities.fixFeatureCollectionReferencing(originalFeatures, sourceCrs);
            result = transformation.evaluate((Object)originalFeatures);
        }
        return result;
    }

    protected abstract GridCoverage2D readCoverage(GridCoverage2DReader var1, Object var2, GridGeometry2D var3) throws IOException;
}

