/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@SupportedResourceType(value=ResourceType.JS)
public class RemoveSourceMapUrlProcessor
implements ResourcePreProcessor {
    public static final String ALIAS = "removeSourceMapUrl";
    protected static final String SOURCE_MAP_URL_PREFIX = "//# sourceMappingURL=";

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.removeAnnotation(reader, writer);
    }

    private void removeAnnotation(Reader reader, Writer writer) throws IOException {
        LineIterator it = IOUtils.lineIterator((Reader)reader);
        while (it.hasNext()) {
            String line = it.next();
            if (line.startsWith(SOURCE_MAP_URL_PREFIX)) continue;
            writer.append(line);
            writer.append(IOUtils.LINE_SEPARATOR);
        }
    }
}

