/*
 * Decompiled with CFR 0.152.
 */
package lizard.tiff;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import lizard.tiff.CodedImage;
import lizard.tiff.IFD;

class RawImage
extends CodedImage {
    public RawImage(IFD ifd) {
        super(ifd);
    }

    public Object getImageProducer() {
        int len;
        int i;
        if (!this.CanDecodeImage()) {
            return null;
        }
        Object img = null;
        if (this.imageBytes == null && this.imageStrips != null) {
            i = 0;
            len = 0;
            while (i < this.imageStrips.length) {
                len += this.imageStrips[i].length;
                ++i;
            }
            this.imageBytes = new byte[len];
            i = 0;
            int n = 0;
            while (i < this.imageStrips.length) {
                System.arraycopy(this.imageStrips[i], 0, this.imageBytes, n, this.imageStrips[i].length);
                n += this.imageStrips[i].length;
                ++i;
            }
            this.imageStrips = null;
        }
        if (this.bitsPerSample == 1) {
            this.Convert1To8Bits();
        }
        if (this.bitsPerSample == 4) {
            this.Convert4To8Bits();
        }
        if (this.samplesPerPixel == 3) {
            len = this.imageBytes.length / 3;
            int[] imagePixels = new int[len];
            i = 0;
            int j = 0;
            while (i < len) {
                imagePixels[i] = 0xFF000000 | ((this.imageBytes[j] & 0xFF) << 16 | (this.imageBytes[j + 1] & 0xFF) << 8 | this.imageBytes[j + 2] & 0xFF);
                ++i;
                j += 3;
            }
            DirectColorModel cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
            return new MemoryImageSource(this.imageWidth, this.imageHeight, (ColorModel)cm, imagePixels, 0, this.imageWidth);
        }
        if (this.bitsPerSample == 8) {
            ColorModel cm = null;
            cm = this.photometric == 3 ? this.makeRGBColorModel() : this.makeColorModel();
            return new MemoryImageSource(this.imageWidth, this.imageHeight, cm, this.imageBytes, 0, this.imageWidth);
        }
        return null;
    }

    public void Convert1To8Bits() {
        byte w;
        byte b;
        System.out.println("Convert1To8Bits() using photometic:" + this.photometric);
        if (this.photometric == 0) {
            b = 0;
            w = -1;
        } else {
            b = -1;
            w = 0;
        }
        byte[][] table = new byte[][]{{w, w, w, w, w, w, w, w}, {w, w, w, w, w, w, w, b}, {w, w, w, w, w, w, b, w}, {w, w, w, w, w, w, b, b}, {w, w, w, w, w, b, w, w}, {w, w, w, w, w, b, w, b}, {w, w, w, w, w, b, b, w}, {w, w, w, w, w, b, b, b}, {w, w, w, w, b, w, w, w}, {w, w, w, w, b, w, w, b}, {w, w, w, w, b, w, b, w}, {w, w, w, w, b, w, b, b}, {w, w, w, w, b, b, w, w}, {w, w, w, w, b, b, w, b}, {w, w, w, w, b, b, b, w}, {w, w, w, w, b, b, b, b}, {w, w, w, b, w, w, w, w}, {w, w, w, b, w, w, w, b}, {w, w, w, b, w, w, b, w}, {w, w, w, b, w, w, b, b}, {w, w, w, b, w, b, w, w}, {w, w, w, b, w, b, w, b}, {w, w, w, b, w, b, b, w}, {w, w, w, b, w, b, b, b}, {w, w, w, b, b, w, w, w}, {w, w, w, b, b, w, w, b}, {w, w, w, b, b, w, b, w}, {w, w, w, b, b, w, b, b}, {w, w, w, b, b, b, w, w}, {w, w, w, b, b, b, w, b}, {w, w, w, b, b, b, b, w}, {w, w, w, b, b, b, b, b}, {w, w, b, w, w, w, w, w}, {w, w, b, w, w, w, w, b}, {w, w, b, w, w, w, b, w}, {w, w, b, w, w, w, b, b}, {w, w, b, w, w, b, w, w}, {w, w, b, w, w, b, w, b}, {w, w, b, w, w, b, b, w}, {w, w, b, w, w, b, b, b}, {w, w, b, w, b, w, w, w}, {w, w, b, w, b, w, w, b}, {w, w, b, w, b, w, b, w}, {w, w, b, w, b, w, b, b}, {w, w, b, w, b, b, w, w}, {w, w, b, w, b, b, w, b}, {w, w, b, w, b, b, b, w}, {w, w, b, w, b, b, b, b}, {w, w, b, b, w, w, w, w}, {w, w, b, b, w, w, w, b}, {w, w, b, b, w, w, b, w}, {w, w, b, b, w, w, b, b}, {w, w, b, b, w, b, w, w}, {w, w, b, b, w, b, w, b}, {w, w, b, b, w, b, b, w}, {w, w, b, b, w, b, b, b}, {w, w, b, b, b, w, w, w}, {w, w, b, b, b, w, w, b}, {w, w, b, b, b, w, b, w}, {w, w, b, b, b, w, b, b}, {w, w, b, b, b, b, w, w}, {w, w, b, b, b, b, w, b}, {w, w, b, b, b, b, b, w}, {w, w, b, b, b, b, b, b}, {w, b, w, w, w, w, w, w}, {w, b, w, w, w, w, w, b}, {w, b, w, w, w, w, b, w}, {w, b, w, w, w, w, b, b}, {w, b, w, w, w, b, w, w}, {w, b, w, w, w, b, w, b}, {w, b, w, w, w, b, b, w}, {w, b, w, w, w, b, b, b}, {w, b, w, w, b, w, w, w}, {w, b, w, w, b, w, w, b}, {w, b, w, w, b, w, b, w}, {w, b, w, w, b, w, b, b}, {w, b, w, w, b, b, w, w}, {w, b, w, w, b, b, w, b}, {w, b, w, w, b, b, b, w}, {w, b, w, w, b, b, b, b}, {w, b, w, b, w, w, w, w}, {w, b, w, b, w, w, w, b}, {w, b, w, b, w, w, b, w}, {w, b, w, b, w, w, b, b}, {w, b, w, b, w, b, w, w}, {w, b, w, b, w, b, w, b}, {w, b, w, b, w, b, b, w}, {w, b, w, b, w, b, b, b}, {w, b, w, b, b, w, w, w}, {w, b, w, b, b, w, w, b}, {w, b, w, b, b, w, b, w}, {w, b, w, b, b, w, b, b}, {w, b, w, b, b, b, w, w}, {w, b, w, b, b, b, w, b}, {w, b, w, b, b, b, b, w}, {w, b, w, b, b, b, b, b}, {w, b, b, w, w, w, w, w}, {w, b, b, w, w, w, w, b}, {w, b, b, w, w, w, b, w}, {w, b, b, w, w, w, b, b}, {w, b, b, w, w, b, w, w}, {w, b, b, w, w, b, w, b}, {w, b, b, w, w, b, b, w}, {w, b, b, w, w, b, b, b}, {w, b, b, w, b, w, w, w}, {w, b, b, w, b, w, w, b}, {w, b, b, w, b, w, b, w}, {w, b, b, w, b, w, b, b}, {w, b, b, w, b, b, w, w}, {w, b, b, w, b, b, w, b}, {w, b, b, w, b, b, b, w}, {w, b, b, w, b, b, b, b}, {w, b, b, b, w, w, w, w}, {w, b, b, b, w, w, w, b}, {w, b, b, b, w, w, b, w}, {w, b, b, b, w, w, b, b}, {w, b, b, b, w, b, w, w}, {w, b, b, b, w, b, w, b}, {w, b, b, b, w, b, b, w}, {w, b, b, b, w, b, b, b}, {w, b, b, b, b, w, w, w}, {w, b, b, b, b, w, w, b}, {w, b, b, b, b, w, b, w}, {w, b, b, b, b, w, b, b}, {w, b, b, b, b, b, w, w}, {w, b, b, b, b, b, w, b}, {w, b, b, b, b, b, b, w}, {w, b, b, b, b, b, b, b}, {b, w, w, w, w, w, w, w}, {b, w, w, w, w, w, w, b}, {b, w, w, w, w, w, b, w}, {b, w, w, w, w, w, b, b}, {b, w, w, w, w, b, w, w}, {b, w, w, w, w, b, w, b}, {b, w, w, w, w, b, b, w}, {b, w, w, w, w, b, b, b}, {b, w, w, w, b, w, w, w}, {b, w, w, w, b, w, w, b}, {b, w, w, w, b, w, b, w}, {b, w, w, w, b, w, b, b}, {b, w, w, w, b, b, w, w}, {b, w, w, w, b, b, w, b}, {b, w, w, w, b, b, b, w}, {b, w, w, w, b, b, b, b}, {b, w, w, b, w, w, w, w}, {b, w, w, b, w, w, w, b}, {b, w, w, b, w, w, b, w}, {b, w, w, b, w, w, b, b}, {b, w, w, b, w, b, w, w}, {b, w, w, b, w, b, w, b}, {b, w, w, b, w, b, b, w}, {b, w, w, b, w, b, b, b}, {b, w, w, b, b, w, w, w}, {b, w, w, b, b, w, w, b}, {b, w, w, b, b, w, b, w}, {b, w, w, b, b, w, b, b}, {b, w, w, b, b, b, w, w}, {b, w, w, b, b, b, w, b}, {b, w, w, b, b, b, b, w}, {b, w, w, b, b, b, b, b}, {b, w, b, w, w, w, w, w}, {b, w, b, w, w, w, w, b}, {b, w, b, w, w, w, b, w}, {b, w, b, w, w, w, b, b}, {b, w, b, w, w, b, w, w}, {b, w, b, w, w, b, w, b}, {b, w, b, w, w, b, b, w}, {b, w, b, w, w, b, b, b}, {b, w, b, w, b, w, w, w}, {b, w, b, w, b, w, w, b}, {b, w, b, w, b, w, b, w}, {b, w, b, w, b, w, b, b}, {b, w, b, w, b, b, w, w}, {b, w, b, w, b, b, w, b}, {b, w, b, w, b, b, b, w}, {b, w, b, w, b, b, b, b}, {b, w, b, b, w, w, w, w}, {b, w, b, b, w, w, w, b}, {b, w, b, b, w, w, b, w}, {b, w, b, b, w, w, b, b}, {b, w, b, b, w, b, w, w}, {b, w, b, b, w, b, w, b}, {b, w, b, b, w, b, b, w}, {b, w, b, b, w, b, b, b}, {b, w, b, b, b, w, w, w}, {b, w, b, b, b, w, w, b}, {b, w, b, b, b, w, b, w}, {b, w, b, b, b, w, b, b}, {b, w, b, b, b, b, w, w}, {b, w, b, b, b, b, w, b}, {b, w, b, b, b, b, b, w}, {b, w, b, b, b, b, b, b}, {b, b, w, w, w, w, w, w}, {b, b, w, w, w, w, w, b}, {b, b, w, w, w, w, b, w}, {b, b, w, w, w, w, b, b}, {b, b, w, w, w, b, w, w}, {b, b, w, w, w, b, w, b}, {b, b, w, w, w, b, b, w}, {b, b, w, w, w, b, b, b}, {b, b, w, w, b, w, w, w}, {b, b, w, w, b, w, w, b}, {b, b, w, w, b, w, b, w}, {b, b, w, w, b, w, b, b}, {b, b, w, w, b, b, w, w}, {b, b, w, w, b, b, w, b}, {b, b, w, w, b, b, b, w}, {b, b, w, w, b, b, b, b}, {b, b, w, b, w, w, w, w}, {b, b, w, b, w, w, w, b}, {b, b, w, b, w, w, b, w}, {b, b, w, b, w, w, b, b}, {b, b, w, b, w, b, w, w}, {b, b, w, b, w, b, w, b}, {b, b, w, b, w, b, b, w}, {b, b, w, b, w, b, b, b}, {b, b, w, b, b, w, w, w}, {b, b, w, b, b, w, w, b}, {b, b, w, b, b, w, b, w}, {b, b, w, b, b, w, b, b}, {b, b, w, b, b, b, w, w}, {b, b, w, b, b, b, w, b}, {b, b, w, b, b, b, b, w}, {b, b, w, b, b, b, b, b}, {b, b, b, w, w, w, w, w}, {b, b, b, w, w, w, w, b}, {b, b, b, w, w, w, b, w}, {b, b, b, w, w, w, b, b}, {b, b, b, w, w, b, w, w}, {b, b, b, w, w, b, w, b}, {b, b, b, w, w, b, b, w}, {b, b, b, w, w, b, b, b}, {b, b, b, w, b, w, w, w}, {b, b, b, w, b, w, w, b}, {b, b, b, w, b, w, b, w}, {b, b, b, w, b, w, b, b}, {b, b, b, w, b, b, w, w}, {b, b, b, w, b, b, w, b}, {b, b, b, w, b, b, b, w}, {b, b, b, w, b, b, b, b}, {b, b, b, b, w, w, w, w}, {b, b, b, b, w, w, w, b}, {b, b, b, b, w, w, b, w}, {b, b, b, b, w, w, b, b}, {b, b, b, b, w, b, w, w}, {b, b, b, b, w, b, w, b}, {b, b, b, b, w, b, b, w}, {b, b, b, b, w, b, b, b}, {b, b, b, b, b, w, w, w}, {b, b, b, b, b, w, w, b}, {b, b, b, b, b, w, b, w}, {b, b, b, b, b, w, b, b}, {b, b, b, b, b, b, w, w}, {b, b, b, b, b, b, w, b}, {b, b, b, b, b, b, b, w}, {b, b, b, b, b, b, b, b}};
        int len = this.imageBytes.length;
        byte[] compressedBytes = new byte[len];
        System.arraycopy(this.imageBytes, 0, compressedBytes, 0, len);
        this.imageBytes = new byte[len * 8 + (this.imageWidth % 8 + 1) * this.imageHeight];
        int maxWidth = 8;
        int scan = this.imageWidth / 8;
        int pad = this.imageWidth % 8;
        if (pad > 0) {
            ++scan;
        }
        int y = 0;
        int n = 0;
        while (y < compressedBytes.length) {
            int x = 0;
            while (x < scan) {
                if (n >= this.imageBytes.length) {
                    System.out.println("oops n=" + n);
                }
                if (x + y >= compressedBytes.length) {
                    System.out.println("oops x+y=" + (x + y));
                }
                System.arraycopy(table[compressedBytes[x + y] & 0xFF], 0, this.imageBytes, n, 8);
                ++x;
                n += 8;
            }
            n -= pad > 0 ? 8 - pad : 0;
            y += scan;
        }
        this.bitsPerSample = 8;
    }

    public void Convert4To8Bits() {
        int len = this.imageBytes.length;
        byte[] compressedBytes = new byte[len];
        System.arraycopy(this.imageBytes, 0, compressedBytes, 0, len);
        this.imageBytes = new byte[len * 2];
        int scan = this.imageWidth / 2;
        System.out.println("size: " + this.imageWidth + "x" + this.imageHeight);
        System.out.println("real: " + this.imageWidth / 2 + "x" + this.imageHeight);
        System.out.println("len: " + compressedBytes.length);
        System.out.println("-->: " + this.imageBytes.length);
        int pad = this.imageWidth % 2;
        if (pad > 0) {
            ++scan;
        }
        int y = 0;
        int n = 0;
        while (y < compressedBytes.length) {
            int x = 0;
            while (x < scan) {
                if (n >= this.imageBytes.length) {
                    System.out.println("oops n=" + n);
                }
                if (n + 1 >= this.imageBytes.length) {
                    System.out.println("oops n+1=" + n);
                }
                if (x + y >= compressedBytes.length) {
                    System.out.println("oops x+y=" + (x + y));
                }
                int b = compressedBytes[x + y] & 0xFF;
                this.imageBytes[n] = (byte)(b >>> 4);
                this.imageBytes[n + 1] = (byte)(b & 0xF);
                ++x;
                n += 2;
            }
            y += scan;
        }
        this.bitsPerSample = 8;
    }
}

