/*
 * Decompiled with CFR 0.152.
 */
package lizard.tiff;

import java.io.IOException;
import lizard.util.MemoryFileInputFilter;
import lizard.util.MotorolaIntelInputFilter;

class Header {
    public static final int TIFF_VERSION = 42;
    public static final int TIFF_BIGENDIAN = 19789;
    public static final int TIFF_LITTLEENDIAN = 18761;
    public static final int SIZE = 8;
    public int byteOrder;
    public int id;
    public long offset;

    public Header() {
        this.init();
    }

    void init() {
        this.byteOrder = 18761;
        this.id = 42;
        this.offset = 10L;
    }

    void write(MotorolaIntelInputFilter out) throws IOException {
        out.writeShort(this.byteOrder);
        out.writeShort(this.id);
        out.writeInt((int)this.offset);
    }

    void read(MemoryFileInputFilter in) {
        this.byteOrder = in.readUnsignedShort();
        in.setByteOrder(this.byteOrder == 18761);
        this.id = in.readUnsignedShort();
        this.offset = in.readInt();
    }

    public String toString() {
        String s = "Byte Order: ";
        s = this.byteOrder == 19789 ? String.valueOf(s) + "Motorola" : String.valueOf(s) + "Intel";
        s = String.valueOf(s) + ", Version: " + this.id + ", Offset: " + Long.toHexString(this.offset);
        return s;
    }
}

