/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiservices.versioning;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.time.DateFormatUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.guiservices.versioning.MetadataAction;
import org.fao.geonet.guiservices.versioning.MetadataActionListSingleton;
import org.fao.geonet.guiservices.versioning.MyLogEntryHandler;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class Get
implements Service {
    private static final String DATE = "date";
    private static final String USERNAME = "user";
    private static final String IP = "ip";
    private static final String ACTION = "action";
    private static final String SUBJECT = "subject";
    private static final String ID = "id";
    private static final String TITLE = "title";
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public final Element exec(Element params, ServiceContext context) throws BadParameterEx, SVNException, IOException, JDOMException {
        MetadataActionListSingleton singleton = MetadataActionListSingleton.getInstance();
        boolean refresh = Util.getParam((Element)params, (String)"refresh", (boolean)true);
        if (refresh) {
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            String repoPath = ((ServiceConfig)gc.getBean(ServiceConfig.class)).getMandatoryValue("subversionPath");
            SVNURL svnurl = SVNURL.fromFile((File)new File(repoPath));
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)svnurl);
            MyLogEntryHandler logEntryHandler = new MyLogEntryHandler();
            List<MetadataAction> oldList = singleton.getMetadataActions();
            Long startRevision = 0L;
            if (oldList != null) {
                startRevision = oldList.get(oldList.size() - 1).getRevision() + 1L;
            }
            if (startRevision <= repository.getLatestRevision()) {
                repository.log(new String[]{""}, startRevision.longValue(), -1L, true, true, (ISVNLogEntryHandler)logEntryHandler);
            }
            List<MetadataAction> newList = logEntryHandler.getMetadataActionList();
            this.addTitles(newList, repoPath);
            if (oldList == null) {
                singleton.setMetadataActions(newList);
            } else if (newList.size() > 0) {
                oldList.addAll(newList);
                singleton.setMetadataActions(oldList);
            }
        }
        ArrayList<MetadataAction> list = new ArrayList<MetadataAction>(singleton.getMetadataActions());
        this.sort(list, params);
        return this.xml(list, params);
    }

    private Element xml(List<MetadataAction> list, Element params) throws BadParameterEx {
        Element root = new Element("logentries");
        Document doc = new Document(root);
        doc.setRootElement(root);
        Element totalCount = new Element("totalcount").setText(String.valueOf(list.size()));
        doc.getRootElement().addContent((Content)totalCount);
        for (MetadataAction metadataAction : this.getSmallerList(list, params)) {
            Element entry = new Element("entry");
            entry.addContent((Content)new Element(DATE).setText(DateFormatUtils.format((Date)metadataAction.getDate(), (String)"dd-MM-yyyy HH:mm:ss")));
            entry.addContent((Content)new Element(USERNAME).setText(metadataAction.getUsername()));
            entry.addContent((Content)new Element(IP).setText(metadataAction.getIp()));
            entry.addContent((Content)new Element(ACTION).setText(metadataAction.translatedAction()));
            entry.addContent((Content)new Element(SUBJECT).setText(metadataAction.translatedSubject()));
            entry.addContent((Content)new Element(ID).setText(String.valueOf(metadataAction.getId())));
            entry.addContent((Content)new Element(TITLE).setText(metadataAction.getTitle()));
            doc.getRootElement().addContent((Content)entry);
        }
        return doc.detachRootElement();
    }

    private List<MetadataAction> getSmallerList(List<MetadataAction> list, Element params) throws BadParameterEx {
        int limit;
        int startPos = Util.getParam((Element)params, (String)"start", (int)0);
        int toIndex = startPos + (limit = Util.getParam((Element)params, (String)"limit", (int)30));
        if (toIndex > list.size()) {
            toIndex = list.size();
        }
        if (startPos < 0 || toIndex == 0) {
            return list;
        }
        return list.subList(startPos, toIndex);
    }

    private void sort(List<MetadataAction> list, Element params) {
        String field = Util.getParam((Element)params, (String)"sort", (String)DATE);
        String direction = Util.getParam((Element)params, (String)"dir", (String)DESC);
        if (direction.compareTo(ASC) == 0) {
            if (field.equals(DATE)) {
                Collections.sort(list, MetadataAction.DATE_COMPARATOR_ASC);
            } else if (field.equals(USERNAME)) {
                Collections.sort(list, MetadataAction.USERNAME_COMPARATOR_ASC);
            } else if (field.equals(IP)) {
                Collections.sort(list, MetadataAction.IP_COMPARATOR_ASC);
            } else if (field.equals(ACTION)) {
                Collections.sort(list, MetadataAction.ACTION_COMPARATOR_ASC);
            } else if (field.equals(SUBJECT)) {
                Collections.sort(list, MetadataAction.SUBJECT_COMPARATOR_ASC);
            } else if (field.equals(ID)) {
                Collections.sort(list, MetadataAction.ID_COMPARATOR_ASC);
            } else if (field.equals(TITLE)) {
                Collections.sort(list, MetadataAction.TITLE_COMPARATOR_ASC);
            }
        } else if (direction.compareTo(DESC) == 0) {
            if (field.equals(DATE)) {
                Collections.sort(list, MetadataAction.DATE_COMPARATOR_DESC);
            } else if (field.equals(USERNAME)) {
                Collections.sort(list, MetadataAction.USERNAME_COMPARATOR_DESC);
            } else if (field.equals(IP)) {
                Collections.sort(list, MetadataAction.IP_COMPARATOR_DESC);
            } else if (field.equals(ACTION)) {
                Collections.sort(list, MetadataAction.ACTION_COMPARATOR_DESC);
            } else if (field.equals(SUBJECT)) {
                Collections.sort(list, MetadataAction.SUBJECT_COMPARATOR_DESC);
            } else if (field.equals(ID)) {
                Collections.sort(list, MetadataAction.ID_COMPARATOR_DESC);
            } else if (field.equals(TITLE)) {
                Collections.sort(list, MetadataAction.TITLE_COMPARATOR_DESC);
            }
        }
    }

    void addTitles(List<MetadataAction> metadataActions, String localRepoLocation) throws JDOMException, IOException, SVNException {
        SVNURL svnurl = SVNURL.fromFile((File)new File(localRepoLocation));
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)svnurl);
        for (MetadataAction metadataAction : metadataActions) {
            Long revision;
            String path = metadataAction.getId() + "/metadata.xml";
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Long revisionToFetch = revision = metadataAction.getRevision();
            if (metadataAction.getAction() == 'D') {
                revisionToFetch = revision - 1L;
            }
            repository.getFile(path, revisionToFetch.longValue(), null, (OutputStream)out);
            ((OutputStream)out).close();
            metadataAction.setTitle(this.getTitle(out));
        }
    }

    private String getTitle(OutputStream out) throws JDOMException, IOException {
        String xml = out.toString();
        byte[] xmlBytes = xml.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream is = new ByteArrayInputStream(xmlBytes);
        InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
        SAXBuilder sb = Xml.getSAXBuilder((boolean)false);
        Document doc = sb.build((Reader)isr);
        Element element = doc.getRootElement();
        XPath xpath = XPath.newInstance((String)"gmd:identificationInfo/*/gmd:citation/gmd:CI_Citation/gmd:title/gco:CharacterString");
        return xpath.valueOf((Object)element);
    }
}

