/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import javax.persistence.criteria.Root;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.component.ProfileManager;
import jeeves.config.springutil.ServerBeanPropertyUpdater;
import jeeves.server.JeevesProxyInfo;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.site.LogUtils;
import org.fao.geonet.api.site.SiteInformation;
import org.fao.geonet.api.site.model.SettingSet;
import org.fao.geonet.api.site.model.SettingsListResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.doi.client.DoiManager;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.SettingDataType;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.StatusValueNotificationLevel;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.index.Status;
import org.fao.geonet.index.es.EsRestClient;
import org.fao.geonet.index.es.EsServerStatusChecker;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataManager;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.PathSpec;
import org.fao.geonet.repository.SettingRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.ProxyInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/site"})
@Tag(name="site", description="Catalog operations")
@Controller(value="site")
public class SiteApi {
    @Autowired
    SettingManager settingManager;
    @Autowired
    NodeInfo node;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    MetadataDraftRepository metadataDraftRepository;
    @Autowired
    EsRestClient esRestClient;
    @Autowired
    SourceRepository sourceRepository;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    private SystemInfo info;

    public static void reloadServices(ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager settingMan = (SettingManager)gc.getBean(SettingManager.class);
        LogUtils.refreshLogConfiguration();
        try {
            ProxyInfo pi = JeevesProxyInfo.getInstance();
            boolean useProxy = settingMan.getValueAsBool("system/proxy/use", false);
            if (useProxy) {
                String proxyHost = settingMan.getValue("system/proxy/host");
                String proxyPort = settingMan.getValue("system/proxy/port");
                String username = settingMan.getValue("system/proxy/username");
                String password = settingMan.getValue("system/proxy/password");
                pi.setProxyInfo(proxyHost, Integer.valueOf(proxyPort).intValue(), username, password);
            } else {
                pi.setProxyInfo(null, -1, null, null);
            }
            Lib.net.setupProxy(settingMan);
        }
        catch (Exception e) {
            context.error("Reload services. Error: " + e.getMessage());
            context.error((Throwable)e);
            throw new OperationAbortedEx("Parameters saved but cannot set proxy information: " + e.getMessage());
        }
        DoiManager doiManager = (DoiManager)gc.getBean(DoiManager.class);
        doiManager.loadConfig();
        HarvestManager harvestManager = (HarvestManager)context.getBean(HarvestManager.class);
        harvestManager.rescheduleActiveHarvesters();
    }

    @Operation(summary="Get site (or portal) description", description="")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Site description.")})
    @ResponseBody
    public SettingsListResponse getSiteOrPortalDescription(@Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String nodeDefault;
        Optional source;
        SettingsListResponse response = new SettingsListResponse();
        response.setSettings(this.settingManager.getSettings(new String[]{"system/site/name", "system/site/organization", "system/site/siteId", "system/platform/version", "system/platform/subVersion"}));
        if ("srv".equals(this.node.getId())) {
            source = this.sourceRepository.findById((Object)this.settingManager.getSiteId());
            nodeDefault = "true";
        } else {
            source = this.sourceRepository.findById((Object)this.node.getId());
            nodeDefault = "false";
        }
        if (source.isPresent()) {
            List<Setting> settings = response.getSettings();
            String iso3langCode = this.languageUtils.getIso3langCode(request.getLocales());
            settings.add(new Setting().setName("node/default").setValue(nodeDefault));
            settings.add(new Setting().setName("node/id").setValue(((Source)source.get()).getUuid()));
            settings.add(new Setting().setName("node/name").setValue(StringUtils.isEmpty((String)((Source)source.get()).getLabel(iso3langCode)) ? ((Source)source.get()).getName() : ((Source)source.get()).getLabel(iso3langCode)));
        }
        return response;
    }

    @Operation(summary="Get settings", description="Return public settings for anonymous users, internals are allowed for authenticated.")
    @RequestMapping(path={"/settings"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Settings.")})
    @ResponseBody
    public SettingsListResponse getSettingsSet(@Parameter(description="Setting set. A common set of settings to retrieve.", required=false) @RequestParam(required=false) SettingSet[] set, @Parameter(description="Setting key", required=false) @RequestParam(required=false) String[] key, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile profile = session == null ? null : session.getProfile();
        ArrayList settingList = new ArrayList();
        if (set == null && key == null) {
            SettingRepository settingRepository = (SettingRepository)appContext.getBean(SettingRepository.class);
            List publicSettings = settingRepository.findAllByInternal(false);
            String mailServer = this.settingManager.getValue("system/feedback/mailServer/host");
            publicSettings.add(new Setting().setName("system/feedback/mailServer/hostIsDefined").setDataType(SettingDataType.BOOLEAN).setValue(StringUtils.isNotEmpty((String)mailServer) + ""));
            SettingsListResponse response = new SettingsListResponse();
            response.setSettings(publicSettings);
            return response;
        }
        if (set != null && set.length > 0) {
            for (SettingSet s : set) {
                String[] props = s.getListOfSettings();
                if (props == null) continue;
                Collections.addAll(settingList, props);
            }
        }
        if (key != null && key.length > 0) {
            Collections.addAll(settingList, key);
        }
        List settings = this.settingManager.getSettings(settingList.toArray(new String[0]));
        ListIterator iterator = settings.listIterator();
        while (iterator.hasNext()) {
            Setting s = (Setting)iterator.next();
            if (!s.isInternal() || profile != null) continue;
            settings.remove(s);
        }
        SettingsListResponse response = new SettingsListResponse();
        response.setSettings(settings);
        return response;
    }

    @Operation(summary="Get settings with details", description="Provides also setting properties.")
    @RequestMapping(path={"/settings/details"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Settings with details.")})
    @ResponseBody
    @PreAuthorize(value="hasAuthority('Administrator')")
    public List<Setting> getSettingsDetails(@Parameter(description="Setting set. A common set of settings to retrieve.", required=false) @RequestParam(required=false) SettingSet[] set, @Parameter(description="Setting key", required=false) @RequestParam(required=false) String[] key, @Parameter(hidden=true) HttpSession httpSession) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        UserSession session = ApiUtils.getUserSession(httpSession);
        Profile profile = session == null ? null : session.getProfile();
        ArrayList settingList = new ArrayList();
        if (set == null && key == null) {
            return this.settingManager.getAll();
        }
        if (set != null && set.length > 0) {
            for (SettingSet s : set) {
                String[] props = s.getListOfSettings();
                if (props == null) continue;
                Collections.addAll(settingList, props);
            }
        }
        if (key != null && key.length > 0) {
            Collections.addAll(settingList, key);
        }
        List settings = this.settingManager.getSettings(settingList.toArray(new String[0]));
        ListIterator iterator = settings.listIterator();
        while (iterator.hasNext()) {
            Setting s = (Setting)iterator.next();
            if (!s.isInternal() || profile != null) continue;
            settings.remove(s);
        }
        return settings;
    }

    @Operation(summary="Save settings", description="")
    @RequestMapping(path={"/settings"}, produces={"application/json"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Settings saved."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    public void saveSettings(@Parameter(hidden=false) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) throws Exception {
        SourceRepository sourceRepository;
        Source siteSource;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        String currentUuid = this.settingManager.getSiteId();
        String oldSiteName = this.settingManager.getSiteName();
        if (!this.settingManager.setValues(allRequestParams)) {
            throw new OperationAbortedEx("Cannot set all values");
        }
        String newSiteName = this.settingManager.getSiteName();
        if (!oldSiteName.equals(newSiteName) && (siteSource = (Source)(sourceRepository = (SourceRepository)applicationContext.getBean(SourceRepository.class)).findById((Object)currentUuid).get()) != null) {
            siteSource.setName(newSiteName);
            siteSource.getLabelTranslations().forEach((l, t) -> siteSource.getLabelTranslations().put(l, newSiteName));
            sourceRepository.save((Object)siteSource);
        }
        String zoneId = StringUtils.defaultIfBlank((String)this.settingManager.getValue("system/server/timeZone", true), (String)SettingManager.DEFAULT_SERVER_TIMEZONE.getId());
        TimeZone.setDefault(TimeZone.getTimeZone(zoneId));
        String newUuid = allRequestParams.get("system/site/siteId");
        if (newUuid != null && !currentUuid.equals(newUuid)) {
            IMetadataManager metadataRepository = (IMetadataManager)applicationContext.getBean(IMetadataManager.class);
            SourceRepository sourceRepository2 = (SourceRepository)applicationContext.getBean(SourceRepository.class);
            Source source = (Source)sourceRepository2.findById((Object)currentUuid).get();
            Source newSource = new Source(newUuid, source.getName(), source.getLabelTranslations(), source.getType());
            sourceRepository2.save((Object)newSource);
            PathSpec<Metadata, String> servicesPath = new PathSpec<Metadata, String>(){

                public javax.persistence.criteria.Path<String> getPath(Root<Metadata> root) {
                    return root.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.sourceId);
                }
            };
            metadataRepository.createBatchUpdateQuery((PathSpec)servicesPath, newUuid, MetadataSpecs.isHarvested((boolean)false));
            sourceRepository2.delete((Object)source);
        }
        SettingInfo info = (SettingInfo)applicationContext.getBean(SettingInfo.class);
        ServiceContext context = ApiUtils.createServiceContext(request);
        ServerBeanPropertyUpdater.updateURL((String)(info.getSiteUrl() + context.getBaseUrl()), (ApplicationContext)applicationContext);
        SiteApi.reloadServices(context);
    }

    @Operation(summary="Get site informations", description="")
    @RequestMapping(path={"/info"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Site information.")})
    @ResponseBody
    public SiteInformation getInformation(HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return new SiteInformation(context, (GeonetContext)context.getHandlerContext("contextName"));
    }

    @Operation(summary="Is CAS enabled?", description="")
    @RequestMapping(path={"/info/isCasEnabled"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isCasEnabled(HttpServletRequest request) throws Exception {
        ApiUtils.createServiceContext(request);
        return ProfileManager.isCasEnabled();
    }

    @Operation(summary="Update staging profile", description="TODO: Needs doc")
    @RequestMapping(path={"/info/staging/{profile}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Staging profile saved."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    public void updateStagingProfile(@PathVariable SystemInfo.Staging profile) {
        this.info.setStagingProfile(profile.toString());
    }

    @Operation(summary="Is in read-only mode?", description="")
    @RequestMapping(path={"/info/readonly"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isReadOnly() throws Exception {
        return ((NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class)).isReadOnly();
    }

    @Operation(summary="Is indexing?", description="")
    @RequestMapping(path={"/indexing"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public boolean isIndexing(HttpServletRequest request) throws Exception {
        ApiUtils.createServiceContext(request);
        return ((DataManager)ApplicationContextHolder.get().getBean(DataManager.class)).isIndexing();
    }

    @Operation(summary="Index", description="")
    @RequestMapping(path={"/index"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public HttpEntity index(@Parameter(description="Drop and recreate index", required=false) @RequestParam(required=false, defaultValue="true") boolean reset, @Parameter(description="Asynchronous mode (only on all records. ie. no selection bucket)", required=false) @RequestParam(required=false, defaultValue="false") boolean asynchronous, @Parameter(description="Records having only XLinks", required=false) @RequestParam(required=false, defaultValue="false") boolean havingXlinkOnly, @Parameter(description="Index. By default only remove record index.", required=false) @RequestParam(required=false, defaultValue="records") String[] indices, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        EsSearchManager searchMan = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
        DataManager dataManager = (DataManager)ApplicationContextHolder.get().getBean(DataManager.class);
        boolean isIndexing = dataManager.isIndexing();
        if (isIndexing) {
            throw new NotAllowedException("Indexing is already in progress. Wait for the current task to complete.");
        }
        if (reset) {
            searchMan.init(true, Optional.of(Arrays.asList(indices)));
        }
        if (StringUtils.isEmpty((String)bucket)) {
            BaseMetadataManager metadataManager = (BaseMetadataManager)ApplicationContextHolder.get().getBean(BaseMetadataManager.class);
            metadataManager.synchronizeDbWithIndex(context, Boolean.valueOf(false), Boolean.valueOf(asynchronous));
        } else {
            searchMan.rebuildIndex(context, havingXlinkOnly, false, bucket);
        }
        return new HttpEntity((Object)HttpStatus.CREATED);
    }

    @Operation(summary="Index commit", description="")
    @RequestMapping(path={"/index/commit"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Administrator')")
    public void indexCommit(HttpServletRequest request) throws Exception {
        EsSearchManager searchMan = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
        searchMan.forceIndexChanges();
    }

    @Operation(summary="Index status", description="")
    @RequestMapping(path={"/index/status"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public Status indexStatus(HttpServletRequest request) throws Exception {
        EsServerStatusChecker serverStatusChecker = (EsServerStatusChecker)ApplicationContextHolder.get().getBean(EsServerStatusChecker.class);
        return serverStatusChecker.getStatus();
    }

    @Operation(summary="Index synchronized with database", description="")
    @RequestMapping(path={"/index/synchronized"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> indexAndDbSynchronizationStatus(HttpServletRequest request) throws Exception {
        HashMap<String, Object> info = new HashMap<String, Object>();
        long dbCount = this.metadataRepository.count();
        boolean isMdWorkflowEnable = this.settingManager.getValueAsBool("metadata/workflow/enable");
        if (isMdWorkflowEnable) {
            dbCount += this.metadataDraftRepository.count();
        }
        info.put("db.count", dbCount);
        EsSearchManager searchMan = (EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class);
        CountResponse countResponse = this.esRestClient.getClient().count(new CountRequest(new String[]{searchMan.getDefaultIndex()}), RequestOptions.DEFAULT);
        info.put("index.count", countResponse.getCount());
        return info;
    }

    @Operation(summary="Force to commit pending documents in index.", description="May be used when indexing task is hanging.")
    @PutMapping(path={"/index/commit"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Changes committed.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void commitIndexChanges() throws Exception {
        ((EsSearchManager)ApplicationContextHolder.get().getBean(EsSearchManager.class)).forceIndexChanges();
    }

    @Operation(summary="Get build details", description="To know when and how this version of the application was built.")
    @RequestMapping(path={"/info/build"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Build info.")})
    @ResponseBody
    public SystemInfo getSystemInfo() throws Exception {
        return (SystemInfo)ApplicationContextHolder.get().getBean(SystemInfo.class);
    }

    @Operation(summary="Get notification levels", description="")
    @RequestMapping(path={"/info/notificationLevels"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of notification levels.")})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public StatusValueNotificationLevel[] getNotificationLevel() {
        return StatusValueNotificationLevel.values();
    }

    @Operation(summary="Set catalog logo", description="Logos are stored in the data directory resources/images/harvesting as PNG or GIF images. When a logo is assigned to the catalog, a new image is created in images/logos/<catalogUuid>.png.")
    @RequestMapping(path={"/logo"}, produces={"application/json"}, method={RequestMethod.PUT})
    @PreAuthorize(value="hasAuthority('UserAdmin')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Logo set."), @ApiResponse(responseCode="403", description="Operation not allowed. Only UserAdmins can access it.")})
    public void setLogo(@Parameter(description="Logo to use for the catalog") @RequestParam(value="file") String file, @Parameter(description="Create favicon too", required=false) @RequestParam(defaultValue="false", required=false) boolean asFavicon, HttpServletRequest request) throws Exception {
        block80: {
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            Resources resources = (Resources)appContext.getBean(Resources.class);
            Path logoDirectory = resources.locateHarvesterLogosDirSMVC((ApplicationContext)appContext);
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            Streams.checkFileName((String)file);
            FilePathChecker.verify((String)file);
            String nodeUuid = this.settingManager.getSiteId();
            Resources.ResourceHolder holder = resources.getImage(serviceContext, file, logoDirectory);
            Path resourcesDir = resources.locateResourcesDir(request.getServletContext(), (ApplicationContext)serviceContext.getApplicationContext());
            if (holder == null || holder.getPath() == null) {
                holder = resources.getImage(serviceContext, "images/harvesting/" + file, resourcesDir);
            }
            try (InputStream inputStream = Files.newInputStream(holder.getPath(), new OpenOption[0]);){
                BufferedImage source = ImageIO.read(inputStream);
                if (asFavicon) {
                    try (Resources.ResourceHolder favicon = resources.getWritableImage(serviceContext, "images/logos/favicon.png", resourcesDir);){
                        ApiUtils.createFavicon(source, favicon.getPath());
                        break block80;
                    }
                }
                try (Resources.ResourceHolder logo = resources.getWritableImage(serviceContext, "images/logos/" + nodeUuid + ".png", resourcesDir);
                     Resources.ResourceHolder defaultLogo = resources.getWritableImage(serviceContext, "images/logo.png", resourcesDir);){
                    if (!file.endsWith(".png")) {
                        try (OutputStream logoOut = Files.newOutputStream(logo.getPath(), new OpenOption[0]);
                             OutputStream defLogoOut = Files.newOutputStream(defaultLogo.getPath(), new OpenOption[0]);){
                            ImageIO.write((RenderedImage)source, "png", logoOut);
                            ImageIO.write((RenderedImage)source, "png", defLogoOut);
                            break block80;
                        }
                    }
                    Files.copy(holder.getPath(), logo.getPath(), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(holder.getPath(), defaultLogo.getPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (Exception e) {
                throw new Exception("Unable to move uploaded thumbnail to destination directory. Error: " + e.getMessage());
            }
            finally {
                holder.close();
            }
        }
    }

    @Operation(summary="Get XSL tranformations available", description="XSL transformations may be applied while importing or harvesting records.")
    @RequestMapping(path={"/info/transforms"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="XSLT available.")})
    @ResponseBody
    public List<String> getXslTransformations() throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class);
        try (DirectoryStream<Path> sheets = Files.newDirectoryStream(dataDirectory.getWebappDir().resolve("xsl/conversion/import"));){
            ArrayList<String> list = new ArrayList<String>();
            for (Path sheet : sheets) {
                String id = sheet.toString();
                if (id == null || !id.endsWith(".xsl")) continue;
                String name = com.google.common.io.Files.getNameWithoutExtension((String)sheet.getFileName().toString());
                list.add(name);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }
}

