/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.attachments.Sort;
import org.fao.geonet.api.records.attachments.SortConverter;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataResourceVisibilityConverter;
import org.fao.geonet.events.history.AttachmentAddedEvent;
import org.fao.geonet.events.history.AttachmentDeletedEvent;
import org.fao.geonet.util.ImageUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/records/{metadataUuid}/attachments"})
@Tag(name="records", description="Metadata record operations")
public class AttachmentsApi {
    public static final Integer MIN_IMAGE_SIZE = 1;
    public static final Integer MAX_IMAGE_SIZE = 2048;
    private final ApplicationContext appContext = ApplicationContextHolder.get();
    private Store store;

    public AttachmentsApi() {
    }

    public AttachmentsApi(Store store) {
        this.store = store;
    }

    public static String getFileContentType(Path file) throws IOException {
        String contentType = Files.probeContentType(file);
        if (contentType == null) {
            String ext;
            switch (ext = com.google.common.io.Files.getFileExtension((String)file.getFileName().toString()).toLowerCase()) {
                case "png": 
                case "gif": 
                case "bmp": 
                case "tif": 
                case "tiff": 
                case "jpg": 
                case "jpeg": {
                    contentType = "image/" + ext;
                    break;
                }
                case "txt": 
                case "html": {
                    contentType = "text/" + ext;
                    break;
                }
                default: {
                    contentType = "application/" + ext;
                }
            }
        }
        return contentType;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    @PostConstruct
    public void init() {
        if (this.appContext != null) {
            this.store = (Store)this.appContext.getBean("resourceStore", Store.class);
        }
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(MetadataResourceVisibility.class, (PropertyEditor)new MetadataResourceVisibilityConverter());
        binder.registerCustomEditor(Sort.class, (PropertyEditor)new SortConverter());
    }

    public List<MetadataResource> getResources() {
        return null;
    }

    @Operation(summary="List all metadata attachments", description="<a href='http://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/associating-resources/using-filestore.html'>More info</a>")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the record attachments."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public List<MetadataResource> getAllResources(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="Sort by", example="type") @RequestParam(required=false, defaultValue="name") Sort sort, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @RequestParam(required=false, defaultValue="*.*") String filter, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        List list = this.store.getResources(context, metadataUuid, sort, filter, approved);
        return list;
    }

    @Operation(summary="Delete all uploaded metadata resources")
    @RequestMapping(method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Attachment added."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delResources(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.store.delResources(context, metadataUuid, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentDeletedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), "All attachments").publish((ApplicationContext)ApplicationContextHolder.get());
        }
    }

    @Operation(summary="Create a new resource for a given metadata")
    @PreAuthorize(value="hasAuthority('Editor')")
    @RequestMapping(method={RequestMethod.POST}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Attachment uploaded."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public MetadataResource putResource(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The sharing policy", example="public") @RequestParam(required=false, defaultValue="public") MetadataResourceVisibility visibility, @Parameter(description="The file to upload") @RequestParam(value="file") MultipartFile file, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        MetadataResource resource = this.store.putResource(context, metadataUuid, file, visibility, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null && file != null && !file.isEmpty()) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentAddedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), file.getOriginalFilename()).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return resource;
    }

    @Operation(summary="Create a new resource from a URL for a given metadata")
    @PreAuthorize(value="hasAuthority('Editor')")
    @RequestMapping(method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Attachment added."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public MetadataResource putResourceFromURL(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The sharing policy", example="public") @RequestParam(required=false, defaultValue="public") MetadataResourceVisibility visibility, @Parameter(description="The URL to load in the store") @RequestParam(value="url") URL url, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        MetadataResource resource = this.store.putResource(context, metadataUuid, url, visibility, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null && url != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentAddedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), url.toString()).publish((ApplicationContext)ApplicationContextHolder.get());
        }
        return resource;
    }

    @Operation(summary="Get a metadata resource")
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Record attachment."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to download the resource.")})
    @ResponseBody
    public HttpEntity<byte[]> getResource(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @Parameter(description="Size (only applies to images). From 1px to 2048px.", example="200") @RequestParam(required=false) Integer size, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        try (Store.ResourceHolder file = this.store.getResource(context, metadataUuid, resourceId, approved);){
            ApiUtils.canViewRecord(metadataUuid, request);
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Disposition", (Object)("inline; filename=\"" + file.getMetadata().getFilename() + "\""));
            headers.add((Object)"Cache-Control", (Object)"no-cache");
            String contentType = AttachmentsApi.getFileContentType(file.getPath());
            headers.add((Object)"Content-Type", (Object)contentType);
            if (contentType.startsWith("image/") && size != null) {
                if (size >= MIN_IMAGE_SIZE && size <= MAX_IMAGE_SIZE) {
                    BufferedImage image = ImageIO.read(file.getPath().toFile());
                    BufferedImage resized = ImageUtil.resize((BufferedImage)image, (int)size);
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)resized, "png", output);
                    output.flush();
                    byte[] imagesB = output.toByteArray();
                    output.close();
                    HttpEntity httpEntity = new HttpEntity((Object)imagesB, (MultiValueMap)headers);
                    return httpEntity;
                }
                throw new IllegalArgumentException(String.format("Image can only be resized from %d to %d. You requested %d.", MIN_IMAGE_SIZE, MAX_IMAGE_SIZE, size));
            }
            HttpEntity httpEntity = new HttpEntity((Object)Files.readAllBytes(file.getPath()), (MultiValueMap)headers);
            return httpEntity;
        }
    }

    @Operation(summary="Update the metadata resource visibility")
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Attachment visibility updated."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.PATCH}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataResource patchResource(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @Parameter(description="The visibility", required=true, example="public") @RequestParam(required=true) MetadataResourceVisibility visibility, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.store.patchResourceStatus(context, metadataUuid, resourceId, visibility, approved);
    }

    @Operation(summary="Delete a metadata resource")
    @PreAuthorize(value="hasAuthority('Editor')")
    @RequestMapping(value={"/{resourceId:.+}"}, method={RequestMethod.DELETE})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Attachment visibility removed."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delResource(@Parameter(description="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @Parameter(description="The resource identifier (ie. filename)", required=true) @PathVariable String resourceId, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.store.delResource(context, metadataUuid, resourceId, approved);
        String metadataIdString = ApiUtils.getInternalId(metadataUuid, approved);
        if (metadataIdString != null) {
            long metadataId = Long.parseLong(metadataIdString);
            UserSession userSession = ApiUtils.getUserSession(request.getSession());
            new AttachmentDeletedEvent(Long.valueOf(metadataId), Integer.valueOf(userSession.getUserIdAsInt()), resourceId).publish((ApplicationContext)ApplicationContextHolder.get());
        }
    }
}

