/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.google.common.collect.ImmutableSet;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.sources.http.ServletPathFinder;
import jeeves.services.ReadWriteController;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.elasticsearch.action.search.SearchResponse;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.related.AssociatedRecord;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.api.records.rdf.RdfOutputManager;
import org.fao.geonet.api.records.rdf.RdfSearcher;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.EsFilterBuilder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.util.XslUtil;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="catalogs")
@ReadWriteController
public class CatalogApi {
    public static Set<String> FIELDLIST_PDF = ImmutableSet.builder().add((Object)"id").add((Object)"uuid").add((Object)"tag").add((Object)"codelist_spatialRepresentationType_text").add((Object)"codelist_maintenanceAndUpdateFrequency_text").add((Object)"format").add((Object)"overview").add((Object)"link").add((Object)"standardName").add((Object)"schema").add((Object)"geom").add((Object)"sourceCatalogue").add((Object)"changeDate").add((Object)"resourceTitleObject.default").add((Object)"resourceAbstractObject.default").build();
    @Autowired
    ThesaurusManager thesaurusManager;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    @Autowired
    SettingManager settingManager;
    @Autowired
    EsSearchManager searchManager;
    @Autowired
    AccessManager accessManage;
    @Autowired
    SettingInfo settingInfo;
    @Autowired
    private ServletContext servletContext;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    IsoLanguagesMapper isoLanguagesMapper;

    private static String paramsAsString(Map<String, String> requestParams) {
        String paramNonPaging = "";
        for (Map.Entry<String, String> pair : requestParams.entrySet()) {
            if (pair.getKey().equals("from") || pair.getKey().equals("to")) continue;
            paramNonPaging = paramNonPaging + (paramNonPaging.equals("") ? "" : "&") + pair.getKey() + "=" + pair.getValue();
        }
        return paramNonPaging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Get a set of metadata records as ZIP", description="Metadata Exchange Format (MEF) is returned. MEF is a ZIP file containing the metadata as XML and some others files depending on the version requested. See http://geonetwork-opensource.org/manuals/trunk/eng/users/annexes/mef-format.html.")
    @RequestMapping(value={"/zip"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/zip", "application/x-gn-mef-1-zip", "application/x-gn-mef-2-zip"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return requested records as ZIP."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public void exportAsMef(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="MEF file format.", required=false) @RequestParam(required=false, defaultValue="FULL") MEFLib.Format format, @Parameter(description="With related records (parent and service).", required=false) @RequestParam(required=false, defaultValue="false") boolean withRelated, @Parameter(description="Resolve XLinks in the records.", required=false) @RequestParam(required=false, defaultValue="true") boolean withXLinksResolved, @Parameter(description="Preserve XLink URLs in the records.", required=false) @RequestParam(required=false, defaultValue="false") boolean withXLinkAttribute, @RequestParam(required=false, defaultValue="true") boolean addSchemaLocation, @Parameter(description="Download the approved version", required=false) @RequestParam(required=false, defaultValue="true") boolean approved, @RequestHeader(value="Accept", defaultValue="application/x-gn-mef-2-zip") String acceptHeader, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletResponse response, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        Path file = null;
        Path stylePath = this.dataDirectory.getWebappDir().resolve("xml/schemas/");
        UserSession session = ApiUtils.getUserSession(httpSession);
        Set<String> uuidList = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        Log.info((String)"geonetwork.mef", (Object)"Create export task for selected metadata(s).");
        SelectionManager selectionManger = SelectionManager.getManager((UserSession)session);
        Log.info((String)"geonetwork.mef", (Object)("Current record(s) in selection: " + uuidList.size()));
        ServiceContext context = ApiUtils.createServiceContext(request);
        MEFLib.Version version = MEFLib.Version.find((String)acceptHeader);
        if (version == MEFLib.Version.V1) {
            throw new IllegalArgumentException("MEF version 1 only support one record. Use the /records/{uuid}/formatters/zip to retrieve that format");
        }
        Set<String> allowedUuid = new HashSet<String>();
        for (String uuid : uuidList) {
            try {
                ApiUtils.canViewRecord(uuid, request);
                allowedUuid.add(uuid);
            }
            catch (Exception e) {
                Log.debug((String)"geonetwork.api", (Object)String.format("Not allowed to export record '%s'.", uuid));
            }
        }
        selectionManger.close("metadata");
        selectionManger.addAllSelection("metadata", allowedUuid);
        if (withRelated) {
            int maxhits = Integer.parseInt(this.settingInfo.getSelectionMaxRecords());
            HashSet tmpUuid = new HashSet();
            for (String uuid : allowedUuid) {
                Map<RelatedItemType, List<AssociatedRecord>> associated = MetadataUtils.getAssociated(context, (AbstractMetadata)this.metadataRepository.findOneByUuid(uuid), RelatedItemType.values(), 0, maxhits);
                associated.forEach((type, list) -> list.forEach(r -> tmpUuid.add(r.getUuid())));
            }
            if (selectionManger.addAllSelection("metadata", tmpUuid)) {
                Log.info((String)"geonetwork.mef", (Object)"Child and services added into the selection");
            }
            allowedUuid = selectionManger.getSelection("metadata");
        }
        Log.info((String)"geonetwork.mef", (Object)("Building MEF2 file with " + uuidList.size() + " records."));
        try {
            file = MEFLib.doMEF2Export((ServiceContext)context, allowedUuid, (String)format.toString(), (boolean)false, (Path)stylePath, (boolean)withXLinksResolved, (boolean)withXLinkAttribute, (boolean)false, (boolean)addSchemaLocation, (boolean)approved);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss");
            String fileName = String.format("%s-%s.zip", this.settingManager.getSiteName().replace(" ", ""), df.format(new Date()));
            response.setHeader("Content-Disposition", String.format("inline; filename=\"%s\"", fileName));
            response.setHeader("Content-Length", String.valueOf(Files.size(file)));
            response.setContentType("application/x-gn-mef-2-zip");
            FileUtils.copyFile((File)file.toFile(), (OutputStream)response.getOutputStream());
        }
        finally {
            selectionManger.close("metadata");
        }
    }

    @Operation(summary="Get a set of metadata records as PDF", description="The PDF is a short summary of each records with links to the complete metadata record in different format (ie. landing page on the portal, XML)")
    @RequestMapping(value={"/pdf"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/pdf"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return requested records as PDF."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public void exportAsPdf(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletResponse httpResponse, @Parameter(hidden=true) HttpServletRequest httpRequest) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Set<String> uuidList = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        int maxhits = Integer.parseInt(this.settingInfo.getSelectionMaxRecords());
        SearchResponse searchResponse = this.searchManager.query(String.format("uuid:(\"%s\")", String.join((CharSequence)"\" or \"", uuidList)), EsFilterBuilder.buildPermissionsFilter((ServiceContext)ApiUtils.createServiceContext(httpRequest)), FIELDLIST_PDF, 0, maxhits);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Element request = new Element("request");
        allRequestParams.entrySet().forEach(e -> {
            Element n = new Element((String)e.getKey());
            n.setText((String)e.getValue());
            request.addContent((Content)n);
        });
        Element response = new Element("response");
        Arrays.asList(searchResponse.getHits().getHits()).forEach(h -> {
            Element r = new Element("metadata");
            Map source = h.getSourceAsMap();
            source.entrySet().forEach(e -> {
                Object v = e.getValue();
                if (v instanceof String) {
                    Element t = new Element((String)e.getKey());
                    t.setText((String)v);
                    r.addContent((Content)t);
                } else if (v instanceof HashMap && ((String)e.getKey()).endsWith("Object")) {
                    Element t = new Element((String)e.getKey());
                    HashMap textFields = (HashMap)e.getValue();
                    t.setText((String)textFields.get("default"));
                    r.addContent((Content)t);
                } else if (v instanceof ArrayList && ((String)e.getKey()).equals("link")) {
                    ((ArrayList)v).forEach(i -> {
                        Element t = new Element((String)e.getKey());
                        HashMap linkProperties = (HashMap)i;
                        t.setText((String)linkProperties.get("description") + "|" + (String)linkProperties.get("name") + "|" + (String)linkProperties.get("url") + "|" + (String)linkProperties.get("protocol"));
                        r.addContent((Content)t);
                    });
                } else if (v instanceof HashMap && ((String)e.getKey()).equals("overview")) {
                    Element t = new Element((String)e.getKey());
                    HashMap overviewProperties = (HashMap)v;
                    t.setText((String)overviewProperties.get("url") + "|" + (String)overviewProperties.get("name"));
                    r.addContent((Content)t);
                } else if (v instanceof ArrayList) {
                    ((ArrayList)v).forEach(i -> {
                        if (i instanceof HashMap && ((String)e.getKey()).equals("overview")) {
                            Element t = new Element((String)e.getKey());
                            HashMap overviewProperties = (HashMap)i;
                            t.setText((String)overviewProperties.get("url") + "|" + (String)overviewProperties.get("name"));
                            r.addContent((Content)t);
                        } else if (i instanceof HashMap) {
                            Element t = new Element((String)e.getKey());
                            HashMap tags = (HashMap)i;
                            t.setText((String)tags.get("default"));
                            r.addContent((Content)t);
                        } else {
                            Element t = new Element((String)e.getKey());
                            t.setText((String)i);
                            r.addContent((Content)t);
                        }
                    });
                } else if (v instanceof HashMap && ((String)e.getKey()).equals("geom")) {
                    Element t = new Element((String)e.getKey());
                    t.setText(((HashMap)v).get("coordinates").toString());
                    r.addContent((Content)t);
                } else if (!(v instanceof HashMap)) {
                    Element t = new Element((String)e.getKey());
                    t.setText(v.toString());
                    r.addContent((Content)t);
                }
            });
            response.addContent((Content)r);
        });
        Locale locale = this.languageUtils.parseAcceptLanguage(httpRequest.getLocales());
        String language = IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language());
        language = XslUtil.twoCharLangCode((String)language, (String)"eng").toLowerCase();
        new XsltResponseWriter("env", "search").withJson(String.format("catalog/locales/%s-v4.json", language)).withJson(String.format("catalog/locales/%s-core.json", language)).withJson(String.format("catalog/locales/%s-search.json", language)).withXml(response).withParams(params).withXsl("xslt/services/pdf/portal-present-fop.xsl").asPdf(httpResponse, this.replaceFilenamePlaceholder(this.settingManager.getValue("metadata/pdfReport/pdfName"), "pdf"));
    }

    @Operation(summary="Get a set of metadata records as CSV", description="The CSV is a short summary of each records.")
    @RequestMapping(value={"/csv"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"text/csv"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return requested records as CSV."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public void exportAsCsv(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletResponse httpResponse, @Parameter(hidden=true) HttpServletRequest httpRequest) throws Exception {
        UserSession session = ApiUtils.getUserSession(httpSession);
        Set<String> uuidList = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        int maxhits = Integer.parseInt(this.settingInfo.getSelectionMaxRecords());
        ServiceContext context = ApiUtils.createServiceContext(httpRequest);
        SearchResponse searchResponse = this.searchManager.query(String.format("uuid:(\"%s\")", String.join((CharSequence)"\" or \"", uuidList)), EsFilterBuilder.buildPermissionsFilter((ServiceContext)ApiUtils.createServiceContext(httpRequest)), EsSearchManager.FIELDLIST_CORE, 0, maxhits);
        Element response = new Element("response");
        Arrays.asList(searchResponse.getHits().getHits()).forEach(h -> {
            try {
                response.addContent((Content)this.dataManager.getMetadata(context, (String)h.getSourceAsMap().get("id"), false, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Element r = new XsltResponseWriter(null, "search").withXml(response).withXsl("xslt/services/csv/csv-search.xsl").asElement();
        String fileName = this.replaceFilenamePlaceholder(this.settingManager.getValue("metadata/csvReport/csvName"), "csv");
        httpResponse.setContentType("text/csv");
        httpResponse.addHeader("Content-Disposition", "attachment; filename=" + fileName);
        httpResponse.setContentLength(r.getText().length());
        httpResponse.getWriter().write(r.getText());
    }

    @Operation(summary="Get catalog content as RDF. This endpoint supports the same Lucene query parameters as for the GUI search.", description=".")
    @RequestMapping(method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/rdf+xml", "*"})
    @Parameters(value={@Parameter(name="from", description="Indicates the start position in a sorted list of matches that the client wants to use as the beginning of a page result.", required=false, in=ParameterIn.QUERY, schema=@Schema(type="integer", format="int32", defaultValue="1")), @Parameter(name="hitsPerPage", description="Indicates the number of hits per page.", required=false, in=ParameterIn.QUERY, schema=@Schema(type="integer", format="int32")), @Parameter(name="any", description="Search key", required=false, in=ParameterIn.QUERY, schema=@Schema(type="string")), @Parameter(name="title", description="A search key for the title.", required=false, in=ParameterIn.QUERY, schema=@Schema(type="string")), @Parameter(name="facet.q", description="A search facet in the Lucene index. Use the GeoNetwork GUI search to generate the suitable filter values. Example: standard/dcat-ap&createDateYear/2018&sourceCatalog/6d93613e-2b76-4e26-94af-4b4c420a1758 (filter by creation year and source catalog).", required=false, in=ParameterIn.QUERY, schema=@Schema(type="string")), @Parameter(name="sortBy", description="Lucene sortBy criteria. Relevant values: relevance, title, changeDate.", required=false, in=ParameterIn.QUERY, schema=@Schema(type="string")), @Parameter(name="sortOrder", description="Sort order. Possible values: reverse.", required=false, in=ParameterIn.QUERY, schema=@Schema(type="string")), @Parameter(name="similarity", description="Use the Lucene FuzzyQuery. Values range from 0.0 to 1.0 and defaults to 0.8.", required=false, in=ParameterIn.QUERY, schema=@Schema(type="number", format="float", defaultValue="0.8"))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the catalog content as RDF."), @ApiResponse(responseCode="303", description="Redirect the client to the first in-sequence page resource. This happens when the paging parameters (from, hitsPerPage) are not included in the request.")})
    @ResponseBody
    public void getAsRdf(@Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletResponse response, HttpServletRequest request) throws Exception {
        int prevTo;
        int to;
        String hostURL = this.getHostURL();
        int hitsPerPage = allRequestParams.get("hitsPerPage") != null ? Integer.parseInt(allRequestParams.get("hitsPerPage")) : 0;
        int from = allRequestParams.get("from") != null ? Integer.parseInt(allRequestParams.get("from")) : 0;
        int n = to = allRequestParams.get("to") != null ? Integer.parseInt(allRequestParams.get("to")) : 0;
        if (hitsPerPage <= 0 || from <= 0) {
            if (hitsPerPage <= 0) {
                hitsPerPage = 10;
                allRequestParams.put("hitsPerPage", Integer.toString(hitsPerPage));
            }
            if (from <= 0) {
                from = 1;
                allRequestParams.put("from", Integer.toString(from));
            }
            response.setStatus(303);
            response.setHeader("Location", hostURL + request.getRequestURI() + "?" + CatalogApi.paramsAsString(allRequestParams) + "&from=1&to=" + hitsPerPage);
            return;
        }
        if (hitsPerPage > 1) {
            from = from - from % hitsPerPage + 1;
        }
        if (to <= 0) {
            to = from + hitsPerPage - 1 > 0 ? from + hitsPerPage - 1 : 10;
        }
        allRequestParams.put("to", Integer.toString(to));
        allRequestParams.put("hitsPerPage", Integer.toString(hitsPerPage));
        allRequestParams.put("from", Integer.toString(from));
        ServiceContext context = ApiUtils.createServiceContext(request);
        RdfOutputManager manager = new RdfOutputManager(this.thesaurusManager.buildResultfromThTable(context), hitsPerPage);
        Element params = new Element("params");
        allRequestParams.forEach((k, v) -> params.addContent((Content)new Element(k).setText(v)));
        RdfSearcher rdfSearcher = new RdfSearcher(params, context);
        List results = rdfSearcher.search(context);
        rdfSearcher.close();
        int numberMatched = rdfSearcher.getSize();
        int firstPageFrom = numberMatched > 0 ? 1 : 0;
        int firstPageTo = numberMatched > hitsPerPage ? hitsPerPage : numberMatched;
        int nextFrom = to < numberMatched ? to + 1 : to;
        int nextTo = to + hitsPerPage < numberMatched ? to + hitsPerPage : numberMatched;
        int prevFrom = from - hitsPerPage > 0 ? from - hitsPerPage : 1;
        int n2 = prevTo = to - hitsPerPage > 0 ? to - hitsPerPage : numberMatched;
        int lastPageFrom = 0 < numberMatched % hitsPerPage ? numberMatched - numberMatched % hitsPerPage + 1 : (numberMatched - hitsPerPage + 1 > 0 ? numberMatched - hitsPerPage + 1 : numberMatched);
        long versionTokenETag = rdfSearcher.getVersionToken();
        String canonicalURL = hostURL + request.getRequestURI();
        String currentPage = canonicalURL + "?" + CatalogApi.paramsAsString(allRequestParams) + "&from=" + from + "&to=" + to;
        String lastPage = canonicalURL + "?" + CatalogApi.paramsAsString(allRequestParams) + "&from=" + lastPageFrom + "&to=" + numberMatched;
        String firstPage = canonicalURL + "?" + CatalogApi.paramsAsString(allRequestParams) + "&from=" + firstPageFrom + "&to=" + firstPageTo;
        String previousPage = canonicalURL + "?" + CatalogApi.paramsAsString(allRequestParams) + "&from=" + prevFrom + "&to=" + prevTo;
        String nextPage = canonicalURL + "?" + CatalogApi.paramsAsString(allRequestParams) + "&from=" + nextFrom + "&to=" + nextTo;
        String hydraPagedCollection = "<hydra:PagedCollection xmlns:hydra=\"http://www.w3.org/ns/hydra/core#\" rdf:about=\"" + currentPage.replaceAll("&", "&amp;") + "\">\n<rdf:type rdf:resource=\"hydra:PartialCollectionView\"/><hydra:lastPage>" + lastPage.replaceAll("&", "&amp;") + "</hydra:lastPage>\n<hydra:totalItems rdf:datatype=\"http://www.w3.org/2001/XMLSchema#integer\">" + numberMatched + "</hydra:totalItems>\n" + (prevFrom <= prevTo && prevFrom < from && prevTo < to ? "<hydra:previousPage>" + previousPage.replaceAll("&", "&amp;") + "</hydra:previousPage>\n" : "") + (nextFrom <= nextTo && from < nextFrom && to < nextTo ? "<hydra:nextPage>" + nextPage.replaceAll("&", "&amp;") + "</hydra:nextPage>\n" : "") + "<hydra:firstPage>" + firstPage.replaceAll("&", "&amp;") + "</hydra:firstPage>\n<hydra:itemsPerPage rdf:datatype=\"http://www.w3.org/2001/XMLSchema#integer\">" + hitsPerPage + "</hydra:itemsPerPage>\n</hydra:PagedCollection>";
        File rdfFile = manager.createRdfFile(context, results, 1, hydraPagedCollection);
        try (ServletOutputStream out = response.getOutputStream();
             FileInputStream in = new FileInputStream(rdfFile);){
            int bytesRead;
            byte[] bytes = new byte[1024];
            response.setContentType("application/rdf+xml");
            response.addHeader("ETag", Long.toString(versionTokenETag));
            response.addHeader("Link", "<http://www.w3.org/ns/ldp#Page>; rel=\"type\"");
            response.addHeader("Link", canonicalURL + "; rel=\"canonical\"; etag=" + versionTokenETag);
            response.addHeader("Link", "<" + firstPage + "> ; rel=\"first\"");
            if (nextFrom <= nextTo && from < nextFrom && to < nextTo) {
                response.addHeader("Link", "<" + nextPage + "> ; rel=\"next\"");
            }
            if (prevFrom <= prevTo && prevFrom < from && prevTo < to) {
                response.addHeader("Link", "<" + previousPage + "> ; rel=\"prev\"");
            }
            response.addHeader("Link", "<" + lastPage + "> ; rel=\"last\"");
            while ((bytesRead = ((InputStream)in).read(bytes)) != -1) {
                out.write(bytes, 0, bytesRead);
            }
        }
        catch (FileNotFoundException e) {
            Log.error((String)"geonetwork.api", (Object)("Get catalog content as RDF. Error: " + e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            Log.error((String)"geonetwork.api", (Object)("Get catalog content as RDF. Error: " + e.getMessage()), (Throwable)e);
        }
    }

    private String getHostURL() {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
        ServletPathFinder pathFinder = new ServletPathFinder(this.servletContext);
        return sm.getBaseURL().replaceAll(pathFinder.getBaseUrl() + "/", "");
    }

    private String replaceFilenamePlaceholder(String fileName, String extension) {
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = "document." + extension;
        } else {
            if (!fileName.endsWith("." + extension)) {
                fileName = fileName + "." + extension;
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("siteName", this.settingManager.getSiteName());
            Calendar c = Calendar.getInstance();
            values.put("year", c.get(1) + "");
            values.put("month", c.get(2) + "");
            values.put("day", c.get(5) + "");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat datetimeFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            values.put("date", dateFormat.format(c.getTime()));
            values.put("datetime", datetimeFormat.format(c.getTime()));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss");
            values.put("ISOdatetime", df.format(new Date()));
            StrSubstitutor sub = new StrSubstitutor(values, "{", "}");
            fileName = sub.replace(fileName);
        }
        return fileName;
    }
}

