/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.cssstyle;

import com.google.common.base.CaseFormat;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.cssstyle.service.ICssStyleSettingService;
import org.fao.geonet.domain.CssStyleSetting;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/customstyle"})
@Tag(name="customstyle", description="Functionalities for custom styling")
@Controller(value="stylesheet")
public class CssStyleSettingsService {
    @Autowired
    GeonetworkDataDirectory geonetworkDataDirectory;

    @Operation(summary="Saves custom style variables.", description="Saves custom style variables.")
    @RequestMapping(value={""}, produces={"application/json"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> saveCssStyle(@Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response, @Parameter(name="gnCssStyle") @RequestBody String jsonVariables) throws Exception {
        try {
            this.checkJSONFile(jsonVariables);
            String cleanedVariables = this.convertFormNamesToLessVariablesNames(jsonVariables);
            this.saveLessVariablesOnDB(cleanedVariables);
            this.saveLessVariablesInDataFolder(cleanedVariables);
            return new ResponseEntity(HttpStatus.CREATED);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (Object)("CssStyleSettingsService - saveCssStyle: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Operation(summary="Get CssStyleSettings", description="This returns a map with all Less variables.")
    @RequestMapping(value={""}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Map<String, String> getCssStyle(@Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response) throws Exception {
        ICssStyleSettingService cssStyleSettingService = (ICssStyleSettingService)ApplicationContextHolder.get().getBean("cssStyleSettingService");
        List<CssStyleSetting> currentCssStyleSettings = cssStyleSettingService.getCustomCssSettings();
        if (currentCssStyleSettings == null) {
            return null;
        }
        Map<String, String> map = this.convertLessListToAngularFormat(currentCssStyleSettings);
        return map;
    }

    private Map<String, String> convertLessListToAngularFormat(List<CssStyleSetting> currentCssStyleSettings) throws JSONException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (CssStyleSetting cssStyleSetting : currentCssStyleSettings) {
            if (cssStyleSetting.getVariable().equals("gn-background-image") && cssStyleSetting.getValue() != null && cssStyleSetting.getValue().startsWith("'")) {
                map.put(this.fromDashToCamel(cssStyleSetting.getVariable()), cssStyleSetting.getValue().substring(1, cssStyleSetting.getValue().length() - 1));
                continue;
            }
            map.put(this.fromDashToCamel(cssStyleSetting.getVariable()), cssStyleSetting.getValue());
        }
        return map;
    }

    private void saveLessVariablesOnDB(String jsonLessVariables) throws JSONException {
        List<CssStyleSetting> listLessVariables = this.convertToListOfVariables(jsonLessVariables);
        this.storeListOnDB(listLessVariables);
    }

    private void saveLessVariablesInDataFolder(String cssStyleSettings) throws IOException {
        String dataFolderPath = this.getDataFolder();
        Path lessPath = this.initializeLessFileInDataFolder(dataFolderPath);
        Charset charset = StandardCharsets.UTF_8;
        Files.write(lessPath, cssStyleSettings.getBytes(charset), new OpenOption[0]);
    }

    private String getDataFolder() {
        String path = this.geonetworkDataDirectory.getSystemDataDir().resolve("node_less_files").toString();
        return path;
    }

    private Path initializeLessFileInDataFolder(String path) throws IOException {
        Path lessPath = Paths.get(path + "/gn_dynamic_style.json", new String[0]);
        try {
            Files.createFile(lessPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e1) {
            Files.delete(lessPath);
            Files.createFile(lessPath, new FileAttribute[0]);
        }
        catch (NoSuchFileException e2) {
            Path tmp = lessPath.getParent();
            Files.createDirectories(tmp, new FileAttribute[0]);
            Files.createFile(lessPath, new FileAttribute[0]);
        }
        return lessPath;
    }

    private void storeListOnDB(List<CssStyleSetting> cssVariables) {
        ICssStyleSettingService cssStyleSettingService = (ICssStyleSettingService)ApplicationContextHolder.get().getBean("cssStyleSettingService");
        cssStyleSettingService.saveSettings(cssVariables);
    }

    private List<CssStyleSetting> convertToListOfVariables(String jsonLessVariables) throws JSONException {
        ArrayList<CssStyleSetting> cssVariables = new ArrayList<CssStyleSetting>();
        JSONObject jObject = new JSONObject(jsonLessVariables);
        Iterator iter = jObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (jObject.getString(key) == null) continue;
            cssVariables.add(new CssStyleSetting(key, jObject.getString(key)));
        }
        return cssVariables;
    }

    private String convertFormNamesToLessVariablesNames(String jsonLessVariables) throws JSONException {
        JSONObject input = new JSONObject(jsonLessVariables);
        JSONObject output = new JSONObject();
        Iterator iter = input.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (input.getString(key) == null) continue;
            if (key.equals("gnBackgroundImage") && input.getString(key) != null && !input.getString(key).startsWith("'")) {
                output.put(this.fromCamelToDash(key), (Object)("'" + input.getString(key) + "'"));
                continue;
            }
            output.put(this.fromCamelToDash(key), (Object)input.getString(key));
        }
        return output.toString();
    }

    private void checkJSONFile(String jsonLessVariables) throws JSONException {
        JSONObject input = new JSONObject(jsonLessVariables);
        Iterator iter = input.keys();
        while (iter.hasNext()) {
            Matcher matcher;
            Pattern pattern;
            String key = (String)iter.next();
            if (input.getString(key) == null) continue;
            if (!(key.equals("gnBackgroundImage") || key.equals("gnHeaderHeight") || StringUtils.isEmpty((String)input.getString(key)))) {
                pattern = Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
                matcher = pattern.matcher(input.getString(key));
                if (matcher.matches()) continue;
                throw new JSONException("Invalid color value. It must be in the format #RRGGBB.");
            }
            if (key.equals("gnHeaderHeight") && !StringUtils.isEmpty((String)input.getString(key))) {
                pattern = Pattern.compile("^([0-9])+(px)$");
                matcher = pattern.matcher(input.getString(key));
                if (matcher.matches()) continue;
                throw new JSONException("Invalid pixel value. It must be in the format 100px.");
            }
            if (!key.equals("gnBackgroundImage") || StringUtils.isEmpty((String)input.getString(key)) || (matcher = (pattern = Pattern.compile("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]")).matcher(input.getString(key))).matches()) continue;
            throw new JSONException("Invalid URL in 'gnBackgroundImage' property");
        }
    }

    private String fromDashToCamel(String dashFormat) {
        String upperFormat = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, dashFormat);
        return upperFormat;
    }

    private String fromCamelToDash(String upperFormat) {
        String dashFormat = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, upperFormat);
        return dashFormat;
    }
}

