/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNStatusClient16;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitUtil {
    public static final Comparator FILE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 == o2) {
                return 0;
            }
            File f1 = (File)o1;
            File f2 = (File)o2;
            return f1.getPath().compareTo(f2.getPath());
        }
    };

    public static void driveCommitEditor(ISVNCommitPathHandler handler, Collection paths, ISVNEditor editor, long revision) throws SVNException {
        if (paths == null || paths.isEmpty() || handler == null || editor == null) {
            return;
        }
        String[] pathsArray = paths.toArray(new String[paths.size()]);
        Arrays.sort(pathsArray, SVNPathUtil.PATH_COMPARATOR);
        int index = 0;
        int depth = 0;
        String lastPath = null;
        if ("".equals(pathsArray[index])) {
            handler.handleCommitPath("", editor);
            lastPath = pathsArray[index];
            ++index;
        } else {
            editor.openRoot(revision);
        }
        ++depth;
        while (index < pathsArray.length) {
            boolean closeDir;
            String relativeCommitPath;
            String commonAncestor;
            String commitPath = pathsArray[index];
            SVNErrorManager.assertionFailure(SVNPathUtil.isCanonical(commitPath), "path '" + commitPath + "' is not canonical", SVNLogType.DEFAULT);
            String string = commonAncestor = lastPath == null || "".equals(lastPath) ? "" : SVNPathUtil.getCommonPathAncestor(commitPath, lastPath);
            if (lastPath != null) {
                while (!lastPath.equals(commonAncestor)) {
                    editor.closeDir();
                    --depth;
                    if (lastPath.lastIndexOf(47) >= 0) {
                        lastPath = lastPath.substring(0, lastPath.lastIndexOf(47));
                        continue;
                    }
                    lastPath = "";
                }
            }
            if ((relativeCommitPath = commitPath.substring(commonAncestor.length())).startsWith("/")) {
                relativeCommitPath = relativeCommitPath.substring(1);
            }
            StringTokenizer tokens = new StringTokenizer(relativeCommitPath, "/");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                String string2 = commonAncestor = "".equals(commonAncestor) ? token : commonAncestor + "/" + token;
                if (commonAncestor.equals(commitPath)) break;
                editor.openDir(commonAncestor, revision);
                ++depth;
            }
            if (closeDir = handler.handleCommitPath(commitPath, editor)) {
                lastPath = commitPath;
                ++depth;
            } else {
                lastPath = index + 1 < pathsArray.length ? SVNPathUtil.removeTail(commitPath) : commitPath;
            }
            ++index;
        }
        while (depth > 0) {
            editor.closeDir();
            --depth;
        }
    }

    public static SVNWCAccess createCommitWCAccess(File[] paths, SVNDepth depth, boolean force, Collection relativePaths, final SVNStatusClient16 statusClient) throws SVNException {
        String[] validatedPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            statusClient.checkCancelled();
            File file = paths[i];
            validatedPaths[i] = file.getAbsolutePath().replace(File.separatorChar, '/');
        }
        String rootPath = SVNPathUtil.condencePaths(validatedPaths, relativePaths, depth == SVNDepth.INFINITY);
        if (rootPath == null) {
            return null;
        }
        boolean lockAll = false;
        if (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES) {
            for (String relPath : relativePaths) {
                if (!"".equals(relPath)) continue;
                lockAll = true;
                break;
            }
        }
        File baseDir = new File(rootPath).getAbsoluteFile();
        rootPath = baseDir.getAbsolutePath().replace(File.separatorChar, '/');
        AbstractCollection dirsToLock = new SVNHashSet();
        AbstractCollection dirsToLockRecursively = new SVNHashSet();
        if (relativePaths.isEmpty()) {
            statusClient.checkCancelled();
            String target = SVNWCManager.getActualTarget(baseDir);
            if (!"".equals(target)) {
                SVNFileType targetType = SVNFileType.getType(new File(rootPath));
                relativePaths.add(target);
                if (targetType == SVNFileType.DIRECTORY) {
                    if (depth == SVNDepth.INFINITY || depth == SVNDepth.IMMEDIATES || force && SVNCommitUtil.isRecursiveCommitForced(baseDir)) {
                        dirsToLockRecursively.add(target);
                    } else {
                        dirsToLock.add(target);
                    }
                }
                baseDir = baseDir.getParentFile();
            } else {
                lockAll = true;
            }
        } else if (!lockAll) {
            baseDir = SVNCommitUtil.adjustRelativePaths(baseDir, relativePaths);
            Iterator targets = relativePaths.iterator();
            while (targets.hasNext()) {
                statusClient.checkCancelled();
                String targetPath = (String)targets.next();
                File targetFile = new File(baseDir, targetPath);
                SVNFileType targetKind = SVNFileType.getType(targetFile);
                if (targetKind == SVNFileType.DIRECTORY) {
                    if (depth == SVNDepth.INFINITY || depth == SVNDepth.IMMEDIATES || force && SVNCommitUtil.isRecursiveCommitForced(targetFile)) {
                        dirsToLockRecursively.add(targetPath);
                    } else if (!targetFile.equals(baseDir)) {
                        dirsToLock.add(targetPath);
                    }
                }
                if (targetFile.equals(baseDir)) continue;
                targetPath = SVNPathUtil.removeTail(targetPath);
                for (targetFile = targetFile.getParentFile(); targetFile != null && !targetFile.equals(baseDir) && !dirsToLock.contains(targetPath); targetFile = targetFile.getParentFile()) {
                    dirsToLock.add(targetPath);
                    targetPath = SVNPathUtil.removeTail(targetPath);
                }
            }
        }
        SVNWCAccess baseAccess = SVNWCAccess.newInstance(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
            }

            public void checkCancelled() throws SVNCancelException {
                statusClient.checkCancelled();
            }
        });
        baseAccess.setOptions(statusClient.getOptions());
        try {
            baseAccess.open(baseDir, true, lockAll ? -1 : 0);
            statusClient.checkCancelled();
            dirsToLock = new ArrayList(dirsToLock);
            dirsToLockRecursively = new ArrayList(dirsToLockRecursively);
            Collections.sort((List)((Object)dirsToLock), SVNPathUtil.PATH_COMPARATOR);
            Collections.sort((List)((Object)dirsToLockRecursively), SVNPathUtil.PATH_COMPARATOR);
            if (!lockAll) {
                File pathFile;
                String path;
                ArrayList uniqueDirsToLockRecursively = new ArrayList();
                uniqueDirsToLockRecursively.addAll(dirsToLockRecursively);
                SVNHashMap processedPaths = new SVNHashMap();
                Iterator ps = uniqueDirsToLockRecursively.iterator();
                block8: while (ps.hasNext()) {
                    String pathToLock = (String)ps.next();
                    if (processedPaths.containsKey(pathToLock)) {
                        ps.remove();
                        continue;
                    }
                    processedPaths.put(pathToLock, pathToLock);
                    for (String existingPath : dirsToLockRecursively) {
                        if (!pathToLock.startsWith(existingPath + "/")) continue;
                        ps.remove();
                        continue block8;
                    }
                }
                Collections.sort(uniqueDirsToLockRecursively, SVNPathUtil.PATH_COMPARATOR);
                dirsToLockRecursively = uniqueDirsToLockRecursively;
                SVNCommitUtil.removeRedundantPaths(dirsToLockRecursively, dirsToLock);
                Iterator nonRecusivePaths = dirsToLock.iterator();
                while (nonRecusivePaths.hasNext()) {
                    statusClient.checkCancelled();
                    path = (String)nonRecusivePaths.next();
                    pathFile = new File(baseDir, path);
                    baseAccess.open(pathFile, true, 0);
                }
                Iterator recusivePaths = dirsToLockRecursively.iterator();
                while (recusivePaths.hasNext()) {
                    statusClient.checkCancelled();
                    path = (String)recusivePaths.next();
                    pathFile = new File(baseDir, path);
                    baseAccess.open(pathFile, true, -1);
                }
            }
            for (int i = 0; i < paths.length; ++i) {
                SVNStatus status;
                SVNErrorMessage err;
                statusClient.checkCancelled();
                File path = paths[i].getAbsoluteFile();
                path = path.getAbsoluteFile();
                try {
                    baseAccess.probeRetrieve(path);
                }
                catch (SVNException e) {
                    err = e.getErrorMessage().wrap("Are all the targets part of the same working copy?");
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (depth == SVNDepth.INFINITY || force || SVNFileType.getType(path) != SVNFileType.DIRECTORY || (status = statusClient.doStatus(path, false)) == null || status.getContentsStatus() != SVNStatusType.STATUS_DELETED && status.getContentsStatus() != SVNStatusType.STATUS_REPLACED) continue;
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Cannot non-recursively commit a directory deletion");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (depth != SVNDepth.INFINITY && force) {
                SVNAdminArea[] lockedDirs = baseAccess.getAdminAreas();
                for (int i = 0; i < lockedDirs.length; ++i) {
                    SVNEntry rootEntry;
                    statusClient.checkCancelled();
                    SVNAdminArea dir = lockedDirs[i];
                    if (dir == null || (rootEntry = baseAccess.getEntry(dir.getRoot(), true)).getCopyFromURL() == null) continue;
                    File dirRoot = dir.getRoot();
                    boolean keep = false;
                    for (int j = 0; j < paths.length; ++j) {
                        if (!dirRoot.equals(paths[j])) continue;
                        keep = true;
                        break;
                    }
                    if (keep) continue;
                    baseAccess.closeAdminArea(dir.getRoot());
                }
            }
        }
        catch (SVNException e) {
            baseAccess.close();
            throw e;
        }
        baseAccess.setAnchor(baseDir);
        return baseAccess;
    }

    public static SVNWCAccess[] createCommitWCAccess2(File[] paths, SVNDepth depth, boolean force, Map relativePathsMap, SVNStatusClient16 statusClient) throws SVNException {
        SVNHashMap rootsMap = new SVNHashMap();
        SVNHashMap localRootsCache = new SVNHashMap();
        for (int i = 0; i < paths.length; ++i) {
            File path;
            statusClient.checkCancelled();
            File rootPath = path = paths[i];
            if (rootPath.isFile()) {
                rootPath = rootPath.getParentFile();
            }
            File wcRoot = localRootsCache.containsKey(rootPath) ? (File)localRootsCache.get(rootPath) : SVNWCUtil.getWorkingCopyRoot(rootPath, true);
            localRootsCache.put(path, wcRoot);
            if (!rootsMap.containsKey(wcRoot)) {
                rootsMap.put(wcRoot, new ArrayList());
            }
            Collection wcPaths = (Collection)rootsMap.get(wcRoot);
            wcPaths.add(path);
        }
        ArrayList<SVNWCAccess> result = new ArrayList<SVNWCAccess>();
        try {
            Iterator roots = rootsMap.keySet().iterator();
            while (roots.hasNext()) {
                statusClient.checkCancelled();
                File root = (File)roots.next();
                Collection filesList = (Collection)rootsMap.get(root);
                File[] filesArray = filesList.toArray(new File[filesList.size()]);
                ArrayList relativePaths = new ArrayList();
                SVNWCAccess wcAccess = SVNCommitUtil.createCommitWCAccess(filesArray, depth, force, relativePaths, statusClient);
                relativePathsMap.put(wcAccess, relativePaths);
                result.add(wcAccess);
            }
        }
        catch (SVNException e) {
            for (SVNWCAccess wcAccess : result) {
                wcAccess.close();
            }
            throw e;
        }
        return result.toArray(new SVNWCAccess[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SVNCommitItem[] harvestCommitables(SVNWCAccess baseAccess, Collection paths, Map lockTokens, boolean justLocked, SVNDepth depth, boolean force, Collection changelists, ISVNCommitParameters params) throws SVNException {
        TreeMap commitables = new TreeMap(FILE_COMPARATOR);
        SVNHashSet danglers = new SVNHashSet();
        Iterator targets = paths.iterator();
        boolean isRecursionForced = false;
        do {
            SVNErrorMessage err;
            String target = targets.hasNext() ? (String)targets.next() : "";
            baseAccess.checkCancelled();
            File targetFile = new File(baseAccess.getAnchor(), target);
            String parentPath = SVNPathUtil.removeTail(target);
            SVNAdminArea dir = baseAccess.probeRetrieve(targetFile);
            SVNEntry entry = null;
            try {
                entry = baseAccess.getVersionedEntry(targetFile, false);
            }
            catch (SVNException e) {
                SVNTreeConflictDescription tc;
                if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND && (tc = baseAccess.getTreeConflict(targetFile)) != null) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)targetFile);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                throw e;
            }
            String url = null;
            if (entry.getURL() == null) {
                SVNEntry parentEntry;
                File parentDir;
                if (!entry.isThisDir() && entry.getName() != null && entry.isDirectory() && !entry.isScheduledForAddition() && !entry.isScheduledForReplacement() && SVNFileType.getType(targetFile) == SVNFileType.NONE && (parentDir = targetFile.getParentFile()) != null && (parentEntry = baseAccess.getEntry(parentDir, false)) != null) {
                    url = SVNPathUtil.append(parentEntry.getURL(), SVNEncodingUtil.uriEncode(entry.getName()));
                }
                if (url == null) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Entry for ''{0}'' has no URL", (Object)targetFile);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            } else {
                url = entry.getURL();
            }
            SVNEntry parentEntry = null;
            if (entry.isScheduledForAddition() || entry.isScheduledForReplacement()) {
                try {
                    baseAccess.retrieve(targetFile.getParentFile());
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                        baseAccess.open(targetFile.getParentFile(), true, 0);
                    }
                    throw e;
                }
                parentEntry = baseAccess.getEntry(targetFile.getParentFile(), false);
                if (parentEntry == null) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "''{0}'' is scheduled for addition within unversioned parent", (Object)targetFile);
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else if (parentEntry.isScheduledForAddition() || parentEntry.isScheduledForReplacement()) {
                    danglers.add(targetFile.getParentFile());
                }
            }
            SVNDepth forcedDepth = depth;
            if (entry.isCopied() && entry.getSchedule() == null) {
                if (force) continue;
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Entry for ''{0}'' is marked as 'copied' but is not itself scheduled\nfor addition.  Perhaps you're committing a target that is\ninside an unversioned (or not-yet-versioned) directory?", (Object)targetFile);
                SVNErrorManager.error(err3, SVNLogType.WC);
            } else if (entry.isCopied() && entry.isScheduledForAddition()) {
                if (force) {
                    isRecursionForced = depth != SVNDepth.INFINITY;
                    forcedDepth = SVNDepth.INFINITY;
                }
            } else if (entry.isScheduledForDeletion() && force && depth != SVNDepth.INFINITY) {
                File parentFile = targetFile.getParentFile();
                parentEntry = baseAccess.getEntry(parentFile, false);
                if (parentEntry == null) {
                    try {
                        baseAccess.retrieve(parentFile);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                            baseAccess.open(parentFile, true, 0);
                        }
                        throw e;
                    }
                    parentEntry = baseAccess.getEntry(parentFile, false);
                }
                if (parentEntry != null && parentEntry.isScheduledForDeletion() && paths.contains(parentPath)) continue;
                forcedDepth = SVNDepth.INFINITY;
            }
            File ancestorPath = dir.getRoot();
            SVNWCAccess localAccess = SVNWCAccess.newInstance(null);
            localAccess.open(ancestorPath, false, 0);
            try {
                boolean isRoot;
                while (!(isRoot = localAccess.isWCRoot(ancestorPath))) {
                    File pPath = ancestorPath.getParentFile();
                    localAccess.open(pPath, false, 0);
                    if (localAccess.hasTreeConflict(ancestorPath)) {
                        SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in tree-conflict", (Object)ancestorPath);
                        SVNErrorManager.error(err4, SVNLogType.WC);
                    }
                    ancestorPath = pPath;
                }
            }
            finally {
                localAccess.close();
            }
            SVNCommitUtil.harvestCommitables(commitables, dir, targetFile, parentEntry, entry, url, null, false, false, justLocked, lockTokens, forcedDepth, isRecursionForced, changelists, params, null);
        } while (targets.hasNext());
        Iterator ds = danglers.iterator();
        while (ds.hasNext()) {
            baseAccess.checkCancelled();
            File file = (File)ds.next();
            if (commitables.containsKey(file)) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control\nand is not part of the commit, \nyet its child is part of the commit", (Object)file);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNCommitUtil.filterOutFileExternals(paths, commitables, baseAccess);
        if (isRecursionForced) {
            Iterator items = commitables.values().iterator();
            while (items.hasNext()) {
                String itemPath;
                baseAccess.checkCancelled();
                SVNCommitItem item = (SVNCommitItem)items.next();
                if (item.isDeleted()) {
                    File file = item.getFile();
                    if (item.getKind() == SVNNodeKind.DIR) {
                        if (!file.exists()) {
                            continue;
                        }
                    } else {
                        String name = SVNPathUtil.tail(item.getPath());
                        SVNAdminArea dir = baseAccess.retrieve(item.getFile().getParentFile());
                        if (!dir.getBaseFile(name, false).exists()) continue;
                    }
                }
                if (!item.isContentsModified() && !item.isDeleted() && !item.isPropertiesModified() || paths.contains(itemPath = item.getPath())) continue;
                items.remove();
            }
        }
        return commitables.values().toArray(new SVNCommitItem[commitables.values().size()]);
    }

    public static void filterOutFileExternals(Collection explicitPaths, Map commitables, SVNWCAccess baseAccess) throws SVNException {
        Iterator items = commitables.values().iterator();
        while (items.hasNext()) {
            baseAccess.checkCancelled();
            SVNCommitItem item = (SVNCommitItem)items.next();
            SVNEntry entry = baseAccess.getEntry(item.getFile(), false);
            if (entry == null || !entry.isFile() || entry.getExternalFilePath() == null || explicitPaths.contains(item.getPath())) continue;
            items.remove();
        }
    }

    public static SVNURL translateCommitables(SVNCommitItem[] items, Map decodedPaths) throws SVNException {
        SVNHashMap itemsMap = new SVNHashMap();
        for (int i = 0; i < items.length; ++i) {
            SVNCommitItem item = items[i];
            if (itemsMap.containsKey(item.getURL())) {
                SVNCommitItem oldItem = (SVNCommitItem)itemsMap.get(item.getURL());
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_DUPLICATE_COMMIT_URL, "Cannot commit both ''{0}'' and ''{1}'' as they refer to the same URL", item.getFile(), oldItem.getFile());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            itemsMap.put(item.getURL(), item);
        }
        Iterator urls = itemsMap.keySet().iterator();
        SVNURL baseURL = (SVNURL)urls.next();
        while (urls.hasNext()) {
            SVNURL url = (SVNURL)urls.next();
            baseURL = SVNURLUtil.getCommonURLAncestor(baseURL, url);
        }
        if (itemsMap.containsKey(baseURL)) {
            SVNCommitItem root = (SVNCommitItem)itemsMap.get(baseURL);
            if (root.getKind() != SVNNodeKind.DIR) {
                baseURL = baseURL.removePathTail();
            } else if (root.getKind() == SVNNodeKind.DIR && (root.isAdded() || root.isDeleted() || root.isCopied() || root.isLocked())) {
                baseURL = baseURL.removePathTail();
            }
        }
        if (baseURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Cannot compute base URL for commit operation");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        for (SVNURL url : itemsMap.keySet()) {
            SVNCommitItem item = (SVNCommitItem)itemsMap.get(url);
            String realPath = url.equals(baseURL) ? "" : SVNPathUtil.getRelativePath(baseURL.getPath(), url.getPath());
            decodedPaths.put(realPath, item);
        }
        return baseURL;
    }

    public static Map translateLockTokens(Map lockTokens, String baseURL) {
        TreeMap<String, String> translatedLocks = new TreeMap<String, String>();
        for (String url : lockTokens.keySet()) {
            String token = (String)lockTokens.get(url);
            url = url.equals(baseURL) ? "" : url.substring(baseURL.length() + 1);
            translatedLocks.put(SVNEncodingUtil.uriDecode(url), token);
        }
        lockTokens.clear();
        lockTokens.putAll(translatedLocks);
        return lockTokens;
    }

    public static void harvestCommitables(Map commitables, SVNAdminArea dir, File path, SVNEntry parentEntry, SVNEntry entry, String url, String copyFromURL, boolean copyMode, boolean addsOnly, boolean justLocked, Map lockTokens, SVNDepth depth, boolean forcedRecursion, Collection changelists, ISVNCommitParameters params, Map pathsToExternalsProperties) throws SVNException {
        String externalsProperty;
        boolean commitLock;
        SVNVersionedProperties props;
        boolean commitDeletion;
        SVNErrorMessage err;
        boolean propConflicts;
        boolean specialFile;
        if (commitables.containsKey(path)) {
            return;
        }
        if (dir != null && dir.getWCAccess() != null) {
            dir.getWCAccess().checkCancelled();
        }
        long cfRevision = entry.getCopyFromRevision();
        String cfURL = null;
        if (entry.getKind() != SVNNodeKind.DIR && entry.getKind() != SVNNodeKind.FILE) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", (Object)path);
            SVNErrorManager.error(err2, SVNLogType.WC);
        }
        SVNFileType fileType = SVNFileType.getType(path);
        boolean matchesChangelist = SVNWCAccess.matchesChangeList(changelists, entry);
        if (fileType != SVNFileType.DIRECTORY && fileType != SVNFileType.NONE && !matchesChangelist) {
            return;
        }
        if (fileType == SVNFileType.UNKNOWN) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Unknown entry kind for ''{0}''", (Object)path);
            SVNErrorManager.error(err3, SVNLogType.WC);
        }
        String specialPropertyValue = dir.getProperties(entry.getName()).getStringPropertyValue("svn:special");
        boolean bl = specialFile = fileType == SVNFileType.SYMLINK;
        if (SVNFileType.isSymlinkSupportEnabled() && (specialPropertyValue == null && specialFile || SVNFileUtil.symlinksSupported() && specialPropertyValue != null && !specialFile) && fileType != SVNFileType.NONE) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Entry ''{0}'' has unexpectedly changed special status", (Object)path);
            SVNErrorManager.error(err4, SVNLogType.WC);
        }
        boolean textConflicts = false;
        boolean treeConflicts = dir.hasTreeConflict(entry.getName());
        SVNAdminArea entries = null;
        if (entry.getKind() == SVNNodeKind.DIR) {
            SVNAdminArea childDir = null;
            try {
                childDir = dir.getWCAccess().retrieve(dir.getFile(entry.getName()));
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    childDir = null;
                }
                throw e;
            }
            if (childDir != null && childDir.entries(true) != null && (entries = childDir).getEntry("", false) != null) {
                entry = entries.getEntry("", false);
                dir = childDir;
            }
            propConflicts = dir.hasPropConflict(entry.getName());
            Map<File, SVNTreeConflictDescription> tcs = entry.getTreeConflicts();
            for (File entryPath : tcs.keySet()) {
                SVNTreeConflictDescription tc = tcs.get(entryPath);
                if (tc.getNodeKind() == SVNNodeKind.DIR && depth == SVNDepth.FILES) continue;
                SVNEntry conflictingEntry = null;
                if (tc.getNodeKind() == SVNNodeKind.DIR) {
                    SVNAdminArea childConflictingDir = dir.getWCAccess().getAdminArea(entryPath);
                    if (childConflictingDir != null) {
                        conflictingEntry = childConflictingDir.getEntry("", true);
                    }
                    conflictingEntry = childDir.getEntry(entryPath.getName(), true);
                } else {
                    conflictingEntry = dir.getEntry(entryPath.getName(), true);
                }
                if (changelists != null && !changelists.isEmpty() && (conflictingEntry == null || !SVNWCAccess.matchesChangeList(changelists, conflictingEntry))) continue;
                err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        } else {
            propConflicts = dir.hasPropConflict(entry.getName());
            textConflicts = dir.hasTextConflict(entry.getName());
        }
        if ((propConflicts || textConflicts || treeConflicts) && SVNWCAccess.matchesChangeList(changelists, entry)) {
            SVNErrorMessage err5 = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)path);
            SVNErrorManager.error(err5, SVNLogType.WC);
        }
        if (entry.getURL() != null && !copyMode) {
            url = entry.getURL();
        }
        boolean bl2 = commitDeletion = !addsOnly && (entry.isDeleted() && entry.getSchedule() == null || entry.isScheduledForDeletion() || entry.isScheduledForReplacement());
        if (!addsOnly && !commitDeletion && fileType == SVNFileType.NONE && params != null) {
            ISVNCommitParameters.Action action;
            ISVNCommitParameters.Action action2 = action = entry.getKind() == SVNNodeKind.DIR ? params.onMissingDirectory(path) : params.onMissingFile(path);
            if (action == ISVNCommitParameters.ERROR) {
                SVNErrorMessage err6 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy file ''{0}'' is missing", (Object)path);
                SVNErrorManager.error(err6, SVNLogType.WC);
            } else if (action == ISVNCommitParameters.DELETE) {
                commitDeletion = true;
                entry.scheduleForDeletion();
                dir.saveEntries(false);
            }
        }
        boolean commitAddition = false;
        boolean commitCopy = false;
        if (entry.isScheduledForAddition() || entry.isScheduledForReplacement()) {
            commitAddition = true;
            if (entry.getCopyFromURL() != null) {
                cfURL = entry.getCopyFromURL();
                addsOnly = false;
                commitCopy = true;
            } else {
                addsOnly = true;
            }
        }
        if ((entry.isCopied() || copyMode) && !entry.isDeleted() && entry.getSchedule() == null) {
            long parentRevision = entry.getRevision() - 1L;
            boolean switched = false;
            if (entry != null && parentEntry != null) {
                boolean bl3 = switched = !entry.getURL().equals(SVNPathUtil.append(parentEntry.getURL(), SVNEncodingUtil.uriEncode(path.getName())));
            }
            if (!switched && !dir.getWCAccess().isWCRoot(path)) {
                if (parentEntry != null) {
                    parentRevision = parentEntry.getRevision();
                }
            } else if (!copyMode) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "Did not expect ''{0}'' to be a working copy root", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (parentRevision != entry.getRevision()) {
                commitAddition = true;
                commitCopy = true;
                addsOnly = false;
                cfRevision = entry.getRevision();
                if (copyMode) {
                    cfURL = entry.getURL();
                } else if (copyFromURL != null) {
                    cfURL = copyFromURL;
                } else {
                    err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Commit item ''{0}'' has copy flag but no copyfrom URL", (Object)path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        }
        boolean textModified = false;
        boolean propsModified = false;
        if (commitAddition) {
            SVNFileType addedFileType = SVNFileType.getType(path);
            if (addedFileType == SVNFileType.NONE) {
                SVNErrorMessage err7 = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' is scheduled for addition, but is missing", (Object)path);
                SVNErrorManager.error(err7, SVNLogType.WC);
            }
            SVNVersionedProperties props2 = dir.getProperties(entry.getName());
            SVNVersionedProperties baseProps = dir.getBaseProperties(entry.getName());
            SVNProperties propDiff = null;
            propDiff = entry.isScheduledForReplacement() ? props2.asMap() : baseProps.compareTo(props2).asMap();
            textModified = propDiff != null && propDiff.containsName("svn:eol-style");
            boolean eolChanged = textModified;
            boolean charsetChanged = propDiff != null && propDiff.containsName("svnkit:charset");
            boolean bl4 = textModified = eolChanged || charsetChanged;
            if (entry.getKind() == SVNNodeKind.FILE) {
                if (commitCopy) {
                    boolean bl5 = textModified = propDiff != null && (propDiff.containsName("svn:eol-style") || propDiff.containsName("svnkit:charset"));
                    if (!textModified) {
                        textModified = dir.hasTextModifications(entry.getName(), eolChanged);
                    }
                } else {
                    textModified = true;
                }
            }
            propsModified = propDiff != null && !propDiff.isEmpty();
        } else if (!commitDeletion) {
            props = dir.getProperties(entry.getName());
            SVNVersionedProperties baseProps = dir.getBaseProperties(entry.getName());
            SVNProperties propDiff = baseProps.compareTo(props).asMap();
            textModified = propDiff != null && (propDiff.containsName("svn:eol-style") || propDiff.containsName("svnkit:charset"));
            boolean forceComparison = textModified;
            boolean bl6 = propsModified = propDiff != null && !propDiff.isEmpty();
            if (entry.getKind() == SVNNodeKind.FILE) {
                textModified = dir.hasTextModifications(entry.getName(), forceComparison);
            }
        }
        boolean bl7 = commitLock = entry.getLockToken() != null && (justLocked || textModified || propsModified || commitDeletion || commitAddition || commitCopy);
        if ((commitAddition || commitDeletion || textModified || propsModified || commitCopy || commitLock) && SVNWCAccess.matchesChangeList(changelists, entry)) {
            SVNCommitItem item = new SVNCommitItem(path, SVNURL.parseURIEncoded(url), cfURL != null ? SVNURL.parseURIEncoded(cfURL) : null, entry.getKind(), SVNRevision.create(entry.getRevision()), SVNRevision.create(cfRevision), commitAddition, commitDeletion, propsModified, textModified, commitCopy, commitLock);
            String itemPath = dir.getRelativePath(dir.getWCAccess().retrieve(dir.getWCAccess().getAnchor()));
            if ("".equals(itemPath)) {
                itemPath = itemPath + entry.getName();
            } else if (!"".equals(entry.getName())) {
                itemPath = itemPath + "/" + entry.getName();
            }
            item.setPath(itemPath);
            commitables.put(path, item);
            if (lockTokens != null && entry.getLockToken() != null) {
                lockTokens.put(url, entry.getLockToken());
            }
        }
        if (pathsToExternalsProperties != null && SVNWCAccess.matchesChangeList(changelists, entry) && (externalsProperty = (props = dir.getProperties(entry.getName())).getStringPropertyValue("svn:externals")) != null) {
            pathsToExternalsProperties.put(dir.getFile(entry.getName()), externalsProperty);
        }
        if (entries != null && SVNDepth.EMPTY.compareTo(depth) < 0 && (commitAddition || !commitDeletion)) {
            Iterator ents = entries.entries(copyMode);
            while (ents.hasNext()) {
                String currentCFURL;
                SVNEntry currentEntry;
                if (dir != null && dir.getWCAccess() != null) {
                    dir.getWCAccess().checkCancelled();
                }
                if ((currentEntry = (SVNEntry)ents.next()).isThisDir() || forcedRecursion && currentEntry.isCopied() && currentEntry.getCopyFromURL() != null || currentEntry.getDepth() == SVNDepth.EXCLUDE || entry.isScheduledForReplacement() && currentEntry.isScheduledForDeletion()) continue;
                String string = currentCFURL = cfURL != null ? cfURL : copyFromURL;
                if (currentCFURL != null) {
                    currentCFURL = SVNPathUtil.append(currentCFURL, SVNEncodingUtil.uriEncode(currentEntry.getName()));
                }
                String currentURL = currentEntry.getURL();
                if (copyMode || currentEntry.getURL() == null) {
                    currentURL = SVNPathUtil.append(url, SVNEncodingUtil.uriEncode(currentEntry.getName()));
                }
                File currentFile = dir.getFile(currentEntry.getName());
                if (currentEntry.getKind() == SVNNodeKind.DIR) {
                    SVNAdminArea childDir;
                    if (SVNDepth.FILES.compareTo(depth) >= 0) continue;
                    try {
                        childDir = dir.getWCAccess().retrieve(dir.getFile(currentEntry.getName()));
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                            childDir = null;
                        }
                        throw e;
                    }
                    if (childDir == null) {
                        SVNFileType currentType = SVNFileType.getType(currentFile);
                        if (currentType == SVNFileType.NONE && currentEntry.isScheduledForDeletion()) {
                            if (SVNWCAccess.matchesChangeList(changelists, entry)) {
                                SVNCommitItem item = new SVNCommitItem(currentFile, SVNURL.parseURIEncoded(currentURL), null, currentEntry.getKind(), SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, false, true, false, false, false, false);
                                String dirPath = dir.getRelativePath(dir.getWCAccess().retrieve(dir.getWCAccess().getAnchor()));
                                item.setPath(SVNPathUtil.append(dirPath, currentEntry.getName()));
                                commitables.put(currentFile, item);
                                continue;
                            }
                        } else if (currentType != SVNFileType.NONE) {
                            SVNErrorMessage err8 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is missing or not locked", (Object)currentFile);
                            SVNErrorManager.error(err8, SVNLogType.WC);
                        } else {
                            ISVNCommitParameters.Action action;
                            ISVNCommitParameters.Action action3 = action = params != null ? params.onMissingDirectory(dir.getFile(currentEntry.getName())) : ISVNCommitParameters.ERROR;
                            if (action == ISVNCommitParameters.DELETE) {
                                SVNCommitItem item = new SVNCommitItem(currentFile, SVNURL.parseURIEncoded(currentURL), null, currentEntry.getKind(), SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, false, true, false, false, false, false);
                                String dirPath = dir.getRelativePath(dir.getWCAccess().retrieve(dir.getWCAccess().getAnchor()));
                                item.setPath(SVNPathUtil.append(dirPath, currentEntry.getName()));
                                commitables.put(currentFile, item);
                                currentEntry.scheduleForDeletion();
                                entries.saveEntries(false);
                                continue;
                            }
                            if (action != ISVNCommitParameters.ERROR) continue;
                            SVNErrorMessage err9 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_LOCKED, "Working copy ''{0}'' is missing or not locked", (Object)currentFile);
                            SVNErrorManager.error(err9, SVNLogType.WC);
                        }
                    }
                }
                SVNDepth depthBelowHere = depth;
                if (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES) {
                    depthBelowHere = SVNDepth.EMPTY;
                }
                SVNCommitUtil.harvestCommitables(commitables, dir, currentFile, entry, currentEntry, currentURL, currentCFURL, copyMode, addsOnly, justLocked, lockTokens, depthBelowHere, forcedRecursion, changelists, params, pathsToExternalsProperties);
            }
        }
        if (lockTokens != null && entry.getKind() == SVNNodeKind.DIR && commitDeletion) {
            SVNCommitUtil.collectLocks(dir, lockTokens);
        }
    }

    private static void collectLocks(SVNAdminArea adminArea, Map lockTokens) throws SVNException {
        Iterator ents = adminArea.entries(false);
        while (ents.hasNext()) {
            SVNAdminArea child;
            SVNEntry entry = (SVNEntry)ents.next();
            if (entry.getURL() != null && entry.getLockToken() != null) {
                lockTokens.put(entry.getURL(), entry.getLockToken());
            }
            if (adminArea.getThisDirName().equals(entry.getName()) || !entry.isDirectory()) continue;
            try {
                child = adminArea.getWCAccess().retrieve(adminArea.getFile(entry.getName()));
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                    child = null;
                }
                throw e;
            }
            if (child == null) continue;
            SVNCommitUtil.collectLocks(child, lockTokens);
        }
        adminArea.closeEntries();
    }

    private static void removeRedundantPaths(Collection dirsToLockRecursively, Collection dirsToLock) {
        SVNHashMap processedDirs = new SVNHashMap();
        Iterator paths = dirsToLock.iterator();
        block0: while (paths.hasNext()) {
            String path = (String)paths.next();
            if (processedDirs.containsKey(path)) {
                paths.remove();
                continue;
            }
            processedDirs.put(path, path);
            if (dirsToLockRecursively.contains(path)) {
                paths.remove();
                continue;
            }
            for (String existingPath : dirsToLockRecursively) {
                if (!path.startsWith(existingPath + "/")) continue;
                paths.remove();
                continue block0;
            }
        }
    }

    private static File adjustRelativePaths(File rootFile, Collection relativePaths) throws SVNException {
        String targetName;
        if (relativePaths.contains("") && !"".equals(targetName = SVNWCManager.getActualTarget(rootFile)) && rootFile.getParentFile() != null) {
            rootFile = rootFile.getParentFile();
            ArrayList<String> result = new ArrayList<String>();
            for (String path : relativePaths) {
                path = "".equals(path) ? targetName : SVNPathUtil.append(targetName, path);
                if (result.contains(path)) continue;
                result.add(path);
            }
            relativePaths.clear();
            Collections.sort(result);
            relativePaths.addAll(result);
        }
        return rootFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRecursiveCommitForced(File directory) throws SVNException {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            wcAccess.open(directory, false, 0);
            SVNEntry targetEntry = wcAccess.getEntry(directory, false);
            if (targetEntry != null) {
                boolean bl = targetEntry.isCopied() || targetEntry.isScheduledForDeletion() || targetEntry.isScheduledForReplacement();
                return bl;
            }
        }
        finally {
            wcAccess.close();
        }
        return false;
    }

    public static String validateCommitMessage(String message) {
        if (message == null) {
            return message;
        }
        message = message.replaceAll("\r\n", "\n");
        message = message.replace('\r', '\n');
        return message;
    }
}

